/*
 * Decompiled with CFR 0.152.
 */
package org.fabric3.fabric.executor;

import java.net.URI;
import org.fabric3.fabric.command.AttachExtensionCommand;
import org.fabric3.host.runtime.HostInfo;
import org.fabric3.spi.classloader.ClassLoaderRegistry;
import org.fabric3.spi.classloader.MultiParentClassLoader;
import org.fabric3.spi.executor.CommandExecutor;
import org.fabric3.spi.executor.CommandExecutorRegistry;
import org.fabric3.spi.executor.ExecutionException;
import org.oasisopen.sca.annotation.Constructor;
import org.oasisopen.sca.annotation.EagerInit;
import org.oasisopen.sca.annotation.Init;
import org.oasisopen.sca.annotation.Reference;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@EagerInit
public class AttachExtensionCommandExecutor
implements CommandExecutor<AttachExtensionCommand> {
    private HostInfo info;
    private CommandExecutorRegistry commandExecutorRegistry;
    private ClassLoaderRegistry classLoaderRegistry;

    @Constructor
    public AttachExtensionCommandExecutor(@Reference HostInfo info, @Reference CommandExecutorRegistry commandExecutorRegistry, @Reference ClassLoaderRegistry classLoaderRegistry) {
        this.info = info;
        this.commandExecutorRegistry = commandExecutorRegistry;
        this.classLoaderRegistry = classLoaderRegistry;
    }

    @Init
    public void init() {
        this.commandExecutorRegistry.register(AttachExtensionCommand.class, (CommandExecutor)this);
    }

    public void execute(AttachExtensionCommand command) throws ExecutionException {
        if (!this.info.supportsClassLoaderIsolation()) {
            return;
        }
        URI contributionUri = command.getContribution();
        URI providerUri = command.getProvider();
        MultiParentClassLoader contributionCl = (MultiParentClassLoader)this.classLoaderRegistry.getClassLoader(contributionUri);
        MultiParentClassLoader providerCl = (MultiParentClassLoader)this.classLoaderRegistry.getClassLoader(providerUri);
        contributionCl.addExtensionClassLoader(providerCl);
    }
}

