/*
 * Decompiled with CFR 0.152.
 */
package org.fabric3.fabric.executor;

import java.net.URI;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import javax.xml.namespace.QName;
import org.fabric3.api.annotation.monitor.Monitor;
import org.fabric3.fabric.channel.AbstractFanOutHandler;
import org.fabric3.fabric.channel.AsyncFanOutHandler;
import org.fabric3.fabric.channel.ChannelImpl;
import org.fabric3.fabric.channel.ReplicationHandler;
import org.fabric3.fabric.channel.ReplicationMonitor;
import org.fabric3.fabric.channel.SyncFanOutHandler;
import org.fabric3.fabric.command.BuildChannelsCommand;
import org.fabric3.spi.builder.BuilderException;
import org.fabric3.spi.builder.component.ChannelBindingBuilder;
import org.fabric3.spi.channel.Channel;
import org.fabric3.spi.channel.ChannelManager;
import org.fabric3.spi.channel.RegistrationException;
import org.fabric3.spi.executor.CommandExecutor;
import org.fabric3.spi.executor.CommandExecutorRegistry;
import org.fabric3.spi.executor.ExecutionException;
import org.fabric3.spi.federation.MessageReceiver;
import org.fabric3.spi.federation.ZoneChannelException;
import org.fabric3.spi.federation.ZoneTopologyService;
import org.fabric3.spi.model.physical.PhysicalChannelBindingDefinition;
import org.fabric3.spi.model.physical.PhysicalChannelDefinition;
import org.oasisopen.sca.annotation.Constructor;
import org.oasisopen.sca.annotation.EagerInit;
import org.oasisopen.sca.annotation.Init;
import org.oasisopen.sca.annotation.Reference;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@EagerInit
public class BuildChannelsCommandExecutor
implements CommandExecutor<BuildChannelsCommand> {
    private ChannelManager channelManager;
    private ExecutorService executorService;
    private CommandExecutorRegistry executorRegistry;
    private ReplicationMonitor monitor;
    private ZoneTopologyService topologyService;
    private boolean replicationCapable;
    private Map<Class<? extends PhysicalChannelBindingDefinition>, ChannelBindingBuilder<? extends PhysicalChannelBindingDefinition>> builders = Collections.emptyMap();

    @Constructor
    public BuildChannelsCommandExecutor(@Reference ChannelManager channelManager, @Reference ExecutorService executorService, @Reference CommandExecutorRegistry executorRegistry, @Monitor ReplicationMonitor monitor) {
        this.channelManager = channelManager;
        this.executorService = executorService;
        this.executorRegistry = executorRegistry;
        this.monitor = monitor;
    }

    @Reference(required=false)
    public void setTopologyService(List<ZoneTopologyService> services) {
        if (services != null && !services.isEmpty()) {
            this.topologyService = services.get(0);
            this.replicationCapable = this.topologyService.supportsDynamicChannels();
        }
    }

    @Reference(required=false)
    public void setBuilders(Map<Class<? extends PhysicalChannelBindingDefinition>, ChannelBindingBuilder<? extends PhysicalChannelBindingDefinition>> builders) {
        this.builders = builders;
    }

    @Init
    public void init() {
        this.executorRegistry.register(BuildChannelsCommand.class, (CommandExecutor)this);
    }

    public void execute(BuildChannelsCommand command) throws ExecutionException {
        try {
            List<PhysicalChannelDefinition> definitions = command.getDefinitions();
            for (PhysicalChannelDefinition definition : definitions) {
                ChannelImpl channel;
                URI uri = definition.getUri();
                QName deployable = definition.getDeployable();
                AbstractFanOutHandler fanOutHandler = definition.isSynchronous() ? new SyncFanOutHandler() : new AsyncFanOutHandler(this.executorService);
                if (definition.isReplicate() && this.replicationCapable) {
                    String channelName = uri.toString();
                    ReplicationHandler replicationHandler = new ReplicationHandler(channelName, this.topologyService, this.monitor);
                    channel = new ChannelImpl(uri, deployable, replicationHandler, fanOutHandler);
                    try {
                        this.topologyService.openChannel(channelName, null, (MessageReceiver)replicationHandler);
                    }
                    catch (ZoneChannelException e) {
                        throw new ExecutionException((Throwable)e);
                    }
                } else {
                    channel = new ChannelImpl(uri, deployable, fanOutHandler);
                }
                PhysicalChannelBindingDefinition bindingDefinition = definition.getBindingDefinition();
                this.buildBinding(channel, bindingDefinition);
                this.channelManager.register((Channel)channel);
            }
        }
        catch (RegistrationException e) {
            throw new ExecutionException(e.getMessage(), (Throwable)e);
        }
    }

    private void buildBinding(Channel channel, PhysicalChannelBindingDefinition bindingDefinition) throws ExecutionException {
        if (bindingDefinition != null) {
            ChannelBindingBuilder builder = this.getBuilder(bindingDefinition);
            try {
                builder.build(bindingDefinition, channel);
            }
            catch (BuilderException e) {
                throw new ExecutionException((Throwable)e);
            }
        }
    }

    private ChannelBindingBuilder getBuilder(PhysicalChannelBindingDefinition bindingDefinition) throws ExecutionException {
        ChannelBindingBuilder<? extends PhysicalChannelBindingDefinition> builder = this.builders.get(bindingDefinition.getClass());
        if (builder == null) {
            throw new ExecutionException("Channel binding builder not found for type " + bindingDefinition.getClass());
        }
        return builder;
    }
}

