/*
 * Decompiled with CFR 0.152.
 */
package org.fabric3.fabric.executor;

import java.util.HashMap;
import java.util.Map;
import org.fabric3.fabric.executor.ExecutorNotFoundException;
import org.fabric3.spi.command.Command;
import org.fabric3.spi.executor.CommandExecutor;
import org.fabric3.spi.executor.CommandExecutorRegistry;
import org.fabric3.spi.executor.ExecutionException;
import org.oasisopen.sca.annotation.EagerInit;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@EagerInit
public class CommandExecutorRegistryImpl
implements CommandExecutorRegistry {
    private Map<Class<? extends Command>, CommandExecutor<?>> executors = new HashMap();

    public <T extends Command> void register(Class<T> type, CommandExecutor<T> executor) {
        this.executors.put(type, executor);
    }

    public <T extends Command> void execute(T command) throws ExecutionException {
        Class<?> clazz = command.getClass();
        CommandExecutor<?> executor = this.executors.get(clazz);
        if (executor == null) {
            throw new ExecutorNotFoundException("No registered executor for command: " + clazz.getName(), clazz.getName());
        }
        executor.execute(command);
    }
}

