/*
 * Decompiled with CFR 0.152.
 */
package org.fabric3.fabric.executor;

import java.net.URI;
import org.fabric3.fabric.command.AttachWireCommand;
import org.fabric3.fabric.command.ConnectionCommand;
import org.fabric3.fabric.command.DetachWireCommand;
import org.fabric3.spi.cm.ComponentManager;
import org.fabric3.spi.command.Command;
import org.fabric3.spi.component.Component;
import org.fabric3.spi.executor.CommandExecutor;
import org.fabric3.spi.executor.CommandExecutorRegistry;
import org.fabric3.spi.executor.ExecutionException;
import org.oasisopen.sca.annotation.EagerInit;
import org.oasisopen.sca.annotation.Init;
import org.oasisopen.sca.annotation.Reference;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@EagerInit
public class ConnectionCommandExecutor
implements CommandExecutor<ConnectionCommand> {
    private ComponentManager componentManager;
    private CommandExecutorRegistry commandExecutorRegistry;

    public ConnectionCommandExecutor(@Reference ComponentManager componentManager, @Reference CommandExecutorRegistry commandExecutorRegistry) {
        this.componentManager = componentManager;
        this.commandExecutorRegistry = commandExecutorRegistry;
    }

    @Init
    public void init() {
        this.commandExecutorRegistry.register(ConnectionCommand.class, (CommandExecutor)this);
    }

    public void execute(ConnectionCommand command) throws ExecutionException {
        URI uri = command.getComponentUri();
        Component component = this.componentManager.getComponent(uri);
        if (component == null) {
            throw new ExecutionException("Component not found: " + uri);
        }
        component.startUpdate();
        for (DetachWireCommand detachWireCommand : command.getDetachCommands()) {
            this.commandExecutorRegistry.execute((Command)detachWireCommand);
        }
        for (AttachWireCommand attachWireCommand : command.getAttachCommands()) {
            this.commandExecutorRegistry.execute((Command)attachWireCommand);
        }
        component.endUpdate();
    }
}

