/*
 * Decompiled with CFR 0.152.
 */
package org.fabric3.fabric.executor;

import java.net.URI;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.fabric3.fabric.command.DisposeChannelsCommand;
import org.fabric3.spi.builder.BuilderException;
import org.fabric3.spi.builder.component.ChannelBindingBuilder;
import org.fabric3.spi.channel.Channel;
import org.fabric3.spi.channel.ChannelManager;
import org.fabric3.spi.channel.RegistrationException;
import org.fabric3.spi.executor.CommandExecutor;
import org.fabric3.spi.executor.CommandExecutorRegistry;
import org.fabric3.spi.executor.ExecutionException;
import org.fabric3.spi.federation.ZoneChannelException;
import org.fabric3.spi.federation.ZoneTopologyService;
import org.fabric3.spi.model.physical.PhysicalChannelBindingDefinition;
import org.fabric3.spi.model.physical.PhysicalChannelDefinition;
import org.oasisopen.sca.annotation.Constructor;
import org.oasisopen.sca.annotation.EagerInit;
import org.oasisopen.sca.annotation.Init;
import org.oasisopen.sca.annotation.Reference;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@EagerInit
public class DisposeChannelsCommandExecutor
implements CommandExecutor<DisposeChannelsCommand> {
    private ChannelManager channelManager;
    private CommandExecutorRegistry executorRegistry;
    private ZoneTopologyService topologyService;
    private boolean replicationCapable;
    private Map<Class<? extends PhysicalChannelBindingDefinition>, ChannelBindingBuilder<? extends PhysicalChannelBindingDefinition>> builders = Collections.emptyMap();

    @Reference(required=false)
    public void setTopologyService(List<ZoneTopologyService> services) {
        if (services != null && !services.isEmpty()) {
            this.topologyService = services.get(0);
            this.replicationCapable = this.topologyService.supportsDynamicChannels();
        }
    }

    @Reference(required=false)
    public void setBuilders(Map<Class<? extends PhysicalChannelBindingDefinition>, ChannelBindingBuilder<? extends PhysicalChannelBindingDefinition>> builders) {
        this.builders = builders;
    }

    @Constructor
    public DisposeChannelsCommandExecutor(@Reference ChannelManager channelManager, @Reference CommandExecutorRegistry executorRegistry) {
        this.channelManager = channelManager;
        this.executorRegistry = executorRegistry;
    }

    @Init
    public void init() {
        this.executorRegistry.register(DisposeChannelsCommand.class, (CommandExecutor)this);
    }

    public void execute(DisposeChannelsCommand command) throws ExecutionException {
        try {
            List<PhysicalChannelDefinition> definitions = command.getDefinitions();
            for (PhysicalChannelDefinition definition : definitions) {
                URI uri = definition.getUri();
                Channel channel = this.channelManager.unregister(uri);
                if (definition.isReplicate() && this.replicationCapable) {
                    String channelName = uri.toString();
                    try {
                        this.topologyService.closeChannel(channelName);
                    }
                    catch (ZoneChannelException e) {
                        throw new ExecutionException((Throwable)e);
                    }
                }
                PhysicalChannelBindingDefinition bindingDefinition = definition.getBindingDefinition();
                this.disposeBinding(channel, bindingDefinition);
            }
        }
        catch (RegistrationException e) {
            throw new ExecutionException(e.getMessage(), (Throwable)e);
        }
    }

    private void disposeBinding(Channel channel, PhysicalChannelBindingDefinition bindingDefinition) throws ExecutionException {
        if (bindingDefinition != null) {
            ChannelBindingBuilder builder = this.getBuilder(bindingDefinition);
            try {
                builder.dispose(bindingDefinition, channel);
            }
            catch (BuilderException e) {
                throw new ExecutionException((Throwable)e);
            }
        }
    }

    private ChannelBindingBuilder getBuilder(PhysicalChannelBindingDefinition bindingDefinition) throws ExecutionException {
        ChannelBindingBuilder<? extends PhysicalChannelBindingDefinition> builder = this.builders.get(bindingDefinition.getClass());
        if (builder == null) {
            throw new ExecutionException("Channel binding builder not found for type " + bindingDefinition.getClass());
        }
        return builder;
    }
}

