/*
 * Decompiled with CFR 0.152.
 */
package org.fabric3.fabric.executor;

import java.net.URI;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.fabric3.fabric.builder.BuilderNotFoundException;
import org.fabric3.fabric.command.DisposeComponentCommand;
import org.fabric3.spi.builder.BuilderException;
import org.fabric3.spi.builder.component.ComponentBuilder;
import org.fabric3.spi.builder.component.ComponentBuilderListener;
import org.fabric3.spi.cm.ComponentManager;
import org.fabric3.spi.cm.RegistrationException;
import org.fabric3.spi.component.Component;
import org.fabric3.spi.executor.CommandExecutor;
import org.fabric3.spi.executor.CommandExecutorRegistry;
import org.fabric3.spi.executor.ExecutionException;
import org.fabric3.spi.model.physical.PhysicalComponentDefinition;
import org.oasisopen.sca.annotation.EagerInit;
import org.oasisopen.sca.annotation.Init;
import org.oasisopen.sca.annotation.Reference;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@EagerInit
public class DisposeComponentCommandExecutor
implements CommandExecutor<DisposeComponentCommand> {
    private CommandExecutorRegistry executorRegistry;
    private ComponentManager componentManager;
    private Map<Class<?>, ComponentBuilder> builders;
    private List<ComponentBuilderListener> listeners = Collections.emptyList();

    public DisposeComponentCommandExecutor(@Reference CommandExecutorRegistry executorRegistry, @Reference ComponentManager componentManager) {
        this.executorRegistry = executorRegistry;
        this.componentManager = componentManager;
    }

    @Reference(required=false)
    public void setBuilders(Map<Class<?>, ComponentBuilder> builders) {
        this.builders = builders;
    }

    @Reference(required=false)
    public void setListeners(List<ComponentBuilderListener> listeners) {
        this.listeners = listeners;
    }

    @Init
    public void init() {
        this.executorRegistry.register(DisposeComponentCommand.class, (CommandExecutor)this);
    }

    public void execute(DisposeComponentCommand command) throws ExecutionException {
        PhysicalComponentDefinition definition = command.getDefinition();
        URI uri = definition.getComponentUri();
        try {
            Component component = this.componentManager.unregister(uri);
            ComponentBuilder builder = this.builders.get(definition.getClass());
            if (builder == null) {
                throw new BuilderNotFoundException("Builder not found for " + definition.getClass().getName());
            }
            builder.dispose(definition, component);
            for (ComponentBuilderListener listener : this.listeners) {
                listener.onDispose(component, definition);
            }
        }
        catch (RegistrationException e) {
            throw new ExecutionException("Unexpected exception un-registering component: " + uri, (Throwable)e);
        }
        catch (BuilderNotFoundException e) {
            throw new ExecutionException((Throwable)((Object)e));
        }
        catch (BuilderException e) {
            throw new ExecutionException((Throwable)e);
        }
    }
}

