/*
 * Decompiled with CFR 0.152.
 */
package org.fabric3.fabric.executor;

import java.net.URI;
import java.net.URL;
import java.util.ArrayList;
import org.fabric3.fabric.command.ProvisionExtensionsCommand;
import org.fabric3.fabric.executor.ProvisionedExtensionTracker;
import org.fabric3.host.contribution.ContributionException;
import org.fabric3.host.contribution.ContributionService;
import org.fabric3.host.contribution.ContributionSource;
import org.fabric3.host.contribution.FileContributionSource;
import org.fabric3.host.domain.DeploymentException;
import org.fabric3.host.domain.Domain;
import org.fabric3.spi.contribution.ContributionResolver;
import org.fabric3.spi.contribution.ResolutionException;
import org.fabric3.spi.executor.CommandExecutor;
import org.fabric3.spi.executor.CommandExecutorRegistry;
import org.fabric3.spi.executor.ExecutionException;
import org.oasisopen.sca.annotation.EagerInit;
import org.oasisopen.sca.annotation.Init;
import org.oasisopen.sca.annotation.Reference;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@EagerInit
public class ProvisionExtensionsCommandExecutor
implements CommandExecutor<ProvisionExtensionsCommand> {
    private CommandExecutorRegistry commandExecutorRegistry;
    private ContributionService contributionService;
    private Domain domain;
    private ContributionResolver resolver;
    private ProvisionedExtensionTracker tracker;

    public ProvisionExtensionsCommandExecutor(@Reference(name="domain") Domain domain, @Reference CommandExecutorRegistry commandExecutorRegistry, @Reference ContributionService contributionService, @Reference ContributionResolver resolver, @Reference ProvisionedExtensionTracker tracker) {
        this.commandExecutorRegistry = commandExecutorRegistry;
        this.contributionService = contributionService;
        this.domain = domain;
        this.resolver = resolver;
        this.tracker = tracker;
    }

    @Init
    public void init() {
        this.commandExecutorRegistry.register(ProvisionExtensionsCommand.class, (CommandExecutor)this);
    }

    public void execute(ProvisionExtensionsCommand command) throws ExecutionException {
        try {
            ArrayList<URI> stored = new ArrayList<URI>();
            for (URI uri : command.getExtensionUris()) {
                if (this.contributionService.exists(uri)) continue;
                URL url = this.resolver.resolve(uri);
                FileContributionSource source = new FileContributionSource(uri, url, 0L, true);
                this.contributionService.store((ContributionSource)source);
                stored.add(uri);
                this.tracker.increment(uri);
            }
            if (stored.isEmpty()) {
                return;
            }
            this.contributionService.install(stored);
            this.domain.include(stored);
        }
        catch (ResolutionException e) {
            throw new ExecutionException((Throwable)e);
        }
        catch (ContributionException e) {
            throw new ExecutionException((Throwable)e);
        }
        catch (DeploymentException e) {
            throw new ExecutionException((Throwable)e);
        }
    }
}

