/*
 * Decompiled with CFR 0.152.
 */
package org.fabric3.fabric.executor;

import javax.xml.namespace.QName;
import org.fabric3.api.annotation.monitor.Monitor;
import org.fabric3.fabric.command.StartContextCommand;
import org.fabric3.fabric.executor.ContextMonitor;
import org.fabric3.model.type.component.Scope;
import org.fabric3.spi.component.ComponentException;
import org.fabric3.spi.component.GroupInitializationException;
import org.fabric3.spi.component.ScopeContainer;
import org.fabric3.spi.component.ScopeRegistry;
import org.fabric3.spi.executor.CommandExecutor;
import org.fabric3.spi.executor.CommandExecutorRegistry;
import org.fabric3.spi.executor.ExecutionException;
import org.fabric3.spi.invocation.WorkContext;
import org.oasisopen.sca.annotation.Constructor;
import org.oasisopen.sca.annotation.EagerInit;
import org.oasisopen.sca.annotation.Init;
import org.oasisopen.sca.annotation.Reference;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@EagerInit
public class StartContextCommandExecutor
implements CommandExecutor<StartContextCommand> {
    private ScopeContainer compositeScopeContainer;
    private ScopeContainer domainScopeContainer;
    private CommandExecutorRegistry commandExecutorRegistry;
    private ContextMonitor monitor;

    @Constructor
    public StartContextCommandExecutor(@Reference CommandExecutorRegistry executorRegistry, @Reference ScopeRegistry scopeRegistry, @Monitor ContextMonitor monitor) {
        this.commandExecutorRegistry = executorRegistry;
        this.compositeScopeContainer = scopeRegistry.getScopeContainer(Scope.COMPOSITE);
        this.domainScopeContainer = scopeRegistry.getScopeContainer(Scope.DOMAIN);
        this.monitor = monitor;
    }

    public StartContextCommandExecutor(ScopeRegistry scopeRegistry, @Monitor ContextMonitor monitor) {
        this(null, scopeRegistry, monitor);
    }

    @Init
    public void init() {
        this.commandExecutorRegistry.register(StartContextCommand.class, (CommandExecutor)this);
    }

    public void execute(StartContextCommand command) throws ExecutionException {
        QName deployable = command.getDeployable();
        WorkContext workContext = new WorkContext();
        try {
            this.compositeScopeContainer.startContext(deployable, workContext);
            if (this.domainScopeContainer != null) {
                this.domainScopeContainer.startContext(deployable, workContext);
            }
            if (command.isLog()) {
                this.monitor.deployed(deployable);
            }
        }
        catch (GroupInitializationException e) {
            throw new ExecutionException((Throwable)e);
        }
        catch (ComponentException e) {
            throw new ExecutionException((Throwable)e);
        }
    }
}

