/*
 * Decompiled with CFR 0.152.
 */
package org.fabric3.fabric.executor;

import javax.xml.namespace.QName;
import org.fabric3.api.annotation.monitor.Monitor;
import org.fabric3.fabric.command.StopContextCommand;
import org.fabric3.fabric.executor.ContextMonitor;
import org.fabric3.model.type.component.Scope;
import org.fabric3.spi.component.ComponentException;
import org.fabric3.spi.component.ScopeContainer;
import org.fabric3.spi.component.ScopeRegistry;
import org.fabric3.spi.executor.CommandExecutor;
import org.fabric3.spi.executor.CommandExecutorRegistry;
import org.fabric3.spi.executor.ExecutionException;
import org.fabric3.spi.invocation.WorkContext;
import org.oasisopen.sca.annotation.EagerInit;
import org.oasisopen.sca.annotation.Init;
import org.oasisopen.sca.annotation.Reference;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@EagerInit
public class StopContextCommandExecutor
implements CommandExecutor<StopContextCommand> {
    private CommandExecutorRegistry executorRegistry;
    private ScopeContainer compositeScopeContainer;
    private ScopeContainer domainScopeContainer;
    private ContextMonitor monitor;

    public StopContextCommandExecutor(@Reference CommandExecutorRegistry executorRegistry, @Reference ScopeRegistry scopeRegistry, @Monitor ContextMonitor monitor) {
        this.executorRegistry = executorRegistry;
        this.compositeScopeContainer = scopeRegistry.getScopeContainer(Scope.COMPOSITE);
        this.domainScopeContainer = scopeRegistry.getScopeContainer(Scope.DOMAIN);
        this.monitor = monitor;
    }

    @Init
    public void init() {
        this.executorRegistry.register(StopContextCommand.class, (CommandExecutor)this);
    }

    public void execute(StopContextCommand command) throws ExecutionException {
        QName deployable = command.getDeployable();
        WorkContext workContext = new WorkContext();
        try {
            this.compositeScopeContainer.stopContext(deployable, workContext);
            if (this.domainScopeContainer != null) {
                this.domainScopeContainer.stopContext(deployable, workContext);
            }
            if (this.monitor != null && command.isLog()) {
                this.monitor.undeployed(deployable);
            }
        }
        catch (ComponentException e) {
            throw new ExecutionException((Throwable)e);
        }
    }
}

