/*
 * Decompiled with CFR 0.152.
 */
package org.fabric3.fabric.generator.channel;

import java.net.URI;
import java.util.ArrayList;
import java.util.List;
import javax.xml.namespace.QName;
import org.fabric3.fabric.command.BuildChannelsCommand;
import org.fabric3.fabric.generator.CommandGenerator;
import org.fabric3.fabric.generator.GeneratorNotFoundException;
import org.fabric3.fabric.generator.GeneratorRegistry;
import org.fabric3.model.type.component.BindingDefinition;
import org.fabric3.spi.channel.ChannelIntents;
import org.fabric3.spi.generator.ConnectionBindingGenerator;
import org.fabric3.spi.generator.GenerationException;
import org.fabric3.spi.model.instance.LogicalBinding;
import org.fabric3.spi.model.instance.LogicalChannel;
import org.fabric3.spi.model.instance.LogicalComponent;
import org.fabric3.spi.model.instance.LogicalCompositeComponent;
import org.fabric3.spi.model.instance.LogicalState;
import org.fabric3.spi.model.physical.PhysicalChannelBindingDefinition;
import org.fabric3.spi.model.physical.PhysicalChannelDefinition;
import org.oasisopen.sca.annotation.EagerInit;
import org.oasisopen.sca.annotation.Property;
import org.oasisopen.sca.annotation.Reference;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@EagerInit
public class BuildChannelCommandGenerator
implements CommandGenerator {
    private int order;
    private GeneratorRegistry generatorRegistry;

    public BuildChannelCommandGenerator(@Property(name="order") int order, @Reference GeneratorRegistry generatorRegistry) {
        this.order = order;
        this.generatorRegistry = generatorRegistry;
    }

    @Override
    public int getOrder() {
        return this.order;
    }

    @Override
    public BuildChannelsCommand generate(LogicalComponent<?> component, boolean incremental) throws GenerationException {
        if (!(component instanceof LogicalCompositeComponent)) {
            return null;
        }
        LogicalCompositeComponent composite = (LogicalCompositeComponent)component;
        List<PhysicalChannelDefinition> definitions = this.createDefinitions(composite, incremental);
        if (definitions.isEmpty()) {
            return null;
        }
        return new BuildChannelsCommand(definitions);
    }

    private List<PhysicalChannelDefinition> createDefinitions(LogicalCompositeComponent composite, boolean incremental) throws GenerationException {
        ArrayList<PhysicalChannelDefinition> definitions = new ArrayList<PhysicalChannelDefinition>();
        for (LogicalChannel channel : composite.getChannels()) {
            if (channel.getState() != LogicalState.NEW && incremental) continue;
            URI uri = channel.getUri();
            QName deployable = channel.getDeployable();
            boolean sync = channel.getDefinition().getIntents().contains(ChannelIntents.SYNC_INTENT);
            boolean replicate = channel.getDefinition().getIntents().contains(ChannelIntents.REPLICATE_INTENT);
            PhysicalChannelDefinition definition = new PhysicalChannelDefinition(uri, deployable, sync, replicate);
            this.generateBinding(channel, definition);
            definitions.add(definition);
        }
        return definitions;
    }

    private void generateBinding(LogicalChannel channel, PhysicalChannelDefinition definition) throws GenerationException {
        if (channel.isBound()) {
            LogicalBinding binding = channel.getBinding();
            ConnectionBindingGenerator bindingGenerator = this.getGenerator(binding);
            PhysicalChannelBindingDefinition bindingDefinition = bindingGenerator.generateChannelBinding(binding);
            definition.setBindingDefinition(bindingDefinition);
        }
    }

    private <T extends BindingDefinition> ConnectionBindingGenerator<T> getGenerator(LogicalBinding<T> binding) throws GeneratorNotFoundException {
        return this.generatorRegistry.getConnectionBindingGenerator(binding.getDefinition().getClass());
    }
}

