/*
 * Decompiled with CFR 0.152.
 */
package org.fabric3.fabric.generator.channel;

import java.net.URI;
import java.util.ArrayList;
import java.util.List;
import javax.xml.namespace.QName;
import org.fabric3.fabric.generator.GeneratorNotFoundException;
import org.fabric3.fabric.generator.GeneratorRegistry;
import org.fabric3.fabric.generator.channel.ChannelNotFoundException;
import org.fabric3.fabric.generator.channel.ConnectionGenerator;
import org.fabric3.fabric.model.physical.ChannelSourceDefinition;
import org.fabric3.fabric.model.physical.ChannelTargetDefinition;
import org.fabric3.fabric.model.physical.TypeEventFilterDefinition;
import org.fabric3.model.type.component.BindingDefinition;
import org.fabric3.model.type.component.Implementation;
import org.fabric3.model.type.contract.DataType;
import org.fabric3.model.type.contract.Operation;
import org.fabric3.model.type.definitions.PolicySet;
import org.fabric3.spi.generator.ComponentGenerator;
import org.fabric3.spi.generator.ConnectionBindingGenerator;
import org.fabric3.spi.generator.EventStreamHandlerGenerator;
import org.fabric3.spi.generator.GenerationException;
import org.fabric3.spi.generator.PolicyMetadata;
import org.fabric3.spi.generator.policy.PolicyResolver;
import org.fabric3.spi.generator.policy.PolicyResult;
import org.fabric3.spi.model.instance.LogicalBinding;
import org.fabric3.spi.model.instance.LogicalChannel;
import org.fabric3.spi.model.instance.LogicalComponent;
import org.fabric3.spi.model.instance.LogicalCompositeComponent;
import org.fabric3.spi.model.instance.LogicalConsumer;
import org.fabric3.spi.model.instance.LogicalInvocable;
import org.fabric3.spi.model.instance.LogicalOperation;
import org.fabric3.spi.model.instance.LogicalProducer;
import org.fabric3.spi.model.physical.PhysicalChannelConnectionDefinition;
import org.fabric3.spi.model.physical.PhysicalConnectionSourceDefinition;
import org.fabric3.spi.model.physical.PhysicalConnectionTargetDefinition;
import org.fabric3.spi.model.physical.PhysicalEventFilterDefinition;
import org.fabric3.spi.model.physical.PhysicalEventStreamDefinition;
import org.fabric3.spi.model.physical.PhysicalHandlerDefinition;
import org.fabric3.spi.model.type.java.JavaType;
import org.oasisopen.sca.annotation.Reference;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ConnectionGeneratorImpl
implements ConnectionGenerator {
    private GeneratorRegistry generatorRegistry;
    private PolicyResolver resolver;

    public ConnectionGeneratorImpl(@Reference GeneratorRegistry generatorRegistry, @Reference PolicyResolver resolver) {
        this.generatorRegistry = generatorRegistry;
        this.resolver = resolver;
    }

    @Override
    public List<PhysicalChannelConnectionDefinition> generateProducer(LogicalProducer producer) throws GenerationException {
        ArrayList<PhysicalChannelConnectionDefinition> definitions = new ArrayList<PhysicalChannelConnectionDefinition>();
        LogicalComponent component = (LogicalComponent)producer.getParent();
        ComponentGenerator<LogicalComponent> componentGenerator = this.getGenerator(component);
        PhysicalConnectionSourceDefinition sourceDefinition = componentGenerator.generateConnectionSource(producer);
        URI classLoaderId = component.getDefinition().getContributionUri();
        sourceDefinition.setClassLoaderId(classLoaderId);
        ArrayList<PhysicalEventStreamDefinition> eventStreams = new ArrayList<PhysicalEventStreamDefinition>();
        for (LogicalOperation operation : producer.getOperations()) {
            eventStreams.add(this.generate(operation));
        }
        for (URI uri : producer.getTargets()) {
            LogicalChannel channel = this.getChannelInHierarchy(uri, (LogicalInvocable)producer);
            PhysicalChannelConnectionDefinition definition = !channel.isBound() ? this.generateProducerConnection(producer, channel, sourceDefinition, classLoaderId, eventStreams) : this.generateProducerBinding(producer, channel, sourceDefinition, classLoaderId, eventStreams);
            definitions.add(definition);
        }
        return definitions;
    }

    @Override
    public List<PhysicalChannelConnectionDefinition> generateConsumer(LogicalConsumer consumer) throws GenerationException {
        ArrayList<PhysicalChannelConnectionDefinition> definitions = new ArrayList<PhysicalChannelConnectionDefinition>();
        LogicalComponent component = (LogicalComponent)consumer.getParent();
        ComponentGenerator<LogicalComponent> generator = this.getGenerator(component);
        PhysicalConnectionTargetDefinition targetDefinition = generator.generateConnectionTarget(consumer);
        URI classLoaderId = component.getDefinition().getContributionUri();
        targetDefinition.setClassLoaderId(classLoaderId);
        List<PhysicalEventStreamDefinition> eventStreams = this.generateEventStreams(consumer);
        this.generatePolicy(consumer, eventStreams);
        for (URI uri : consumer.getSources()) {
            LogicalChannel channel = this.getChannelInHierarchy(uri, (LogicalInvocable)consumer);
            PhysicalChannelConnectionDefinition definition = !channel.isBound() ? this.generateConsumerConnection(consumer, channel, targetDefinition, classLoaderId, eventStreams) : this.generateConsumerBinding(consumer, channel, targetDefinition, eventStreams, classLoaderId);
            definitions.add(definition);
        }
        return definitions;
    }

    private PhysicalChannelConnectionDefinition generateConsumerConnection(LogicalConsumer consumer, LogicalChannel channel, PhysicalConnectionTargetDefinition targetDefinition, URI classLoaderId, List<PhysicalEventStreamDefinition> eventStreams) {
        if (!channel.getZone().equals(((LogicalComponent)consumer.getParent()).getZone())) {
            throw new AssertionError((Object)"Binding not configured on a channel where the producer is in a different zone");
        }
        ChannelSourceDefinition sourceDefinition = new ChannelSourceDefinition(channel.getUri());
        sourceDefinition.setClassLoaderId(classLoaderId);
        return new PhysicalChannelConnectionDefinition((PhysicalConnectionSourceDefinition)sourceDefinition, targetDefinition, eventStreams);
    }

    private PhysicalChannelConnectionDefinition generateConsumerBinding(LogicalConsumer consumer, LogicalChannel channel, PhysicalConnectionTargetDefinition targetDefinition, List<PhysicalEventStreamDefinition> eventStreams, URI classLoaderId) throws GenerationException {
        LogicalBinding binding = channel.getBinding();
        ConnectionBindingGenerator bindingGenerator = this.getGenerator(binding);
        PhysicalConnectionSourceDefinition sourceDefinition = bindingGenerator.generateConnectionSource(consumer, binding);
        sourceDefinition.setClassLoaderId(classLoaderId);
        return new PhysicalChannelConnectionDefinition(sourceDefinition, targetDefinition, eventStreams);
    }

    private PhysicalChannelConnectionDefinition generateProducerConnection(LogicalProducer producer, LogicalChannel channel, PhysicalConnectionSourceDefinition sourceDefinition, URI classLoaderId, List<PhysicalEventStreamDefinition> eventStreams) {
        if (!channel.getZone().equals(((LogicalComponent)producer.getParent()).getZone())) {
            throw new AssertionError((Object)"Binding not configured on a channel where the producer is in a different zone");
        }
        ChannelTargetDefinition targetDefinition = new ChannelTargetDefinition(channel.getUri());
        targetDefinition.setClassLoaderId(classLoaderId);
        return new PhysicalChannelConnectionDefinition(sourceDefinition, (PhysicalConnectionTargetDefinition)targetDefinition, eventStreams);
    }

    private PhysicalChannelConnectionDefinition generateProducerBinding(LogicalProducer producer, LogicalChannel channel, PhysicalConnectionSourceDefinition sourceDefinition, URI classLoaderId, List<PhysicalEventStreamDefinition> eventStreams) throws GenerationException {
        LogicalBinding binding = channel.getBinding();
        ConnectionBindingGenerator bindingGenerator = this.getGenerator(binding);
        PhysicalConnectionTargetDefinition targetDefinition = bindingGenerator.generateConnectionTarget(producer, binding);
        targetDefinition.setClassLoaderId(classLoaderId);
        return new PhysicalChannelConnectionDefinition(sourceDefinition, targetDefinition, eventStreams);
    }

    private void generatePolicy(LogicalConsumer consumer, List<PhysicalEventStreamDefinition> eventStreams) throws GenerationException {
        PolicyResult result = this.resolver.resolvePolicies(consumer);
        if (result.getInterceptedPolicySets().isEmpty()) {
            return;
        }
        List policies = (List)result.getInterceptedPolicySets().values().iterator().next();
        PolicyMetadata metadata = (PolicyMetadata)result.getMetadata().values().iterator().next();
        for (PolicySet set : policies) {
            QName expressionName = set.getExpressionName();
            EventStreamHandlerGenerator handlerGenerator = this.generatorRegistry.getEventStreamHandlerGenerator(expressionName);
            PhysicalHandlerDefinition definition = handlerGenerator.generate(set.getExpression(), metadata);
            if (definition == null) continue;
            definition.setPolicyClassLoaderId(set.getContributionUri());
            for (PhysicalEventStreamDefinition streamDefinition : eventStreams) {
                streamDefinition.addHandlerDefinition(definition);
            }
        }
    }

    private PhysicalEventStreamDefinition generate(LogicalOperation operation) {
        Operation o = operation.getDefinition();
        PhysicalEventStreamDefinition definition = new PhysicalEventStreamDefinition(o.getName());
        definition.setName(o.getName());
        List params = o.getInputTypes();
        for (DataType param : params) {
            Class paramType = param.getPhysical();
            String paramName = paramType.getName();
            definition.addEventType(paramName);
        }
        return definition;
    }

    private List<PhysicalEventStreamDefinition> generateEventStreams(LogicalConsumer consumer) {
        ArrayList<PhysicalEventStreamDefinition> streams = new ArrayList<PhysicalEventStreamDefinition>();
        PhysicalEventStreamDefinition definition = new PhysicalEventStreamDefinition("default");
        List types = consumer.getDefinition().getTypes();
        boolean typed = false;
        for (DataType dataType : types) {
            if (dataType instanceof JavaType && !Object.class.equals(dataType.getLogical())) {
                typed = true;
            }
            definition.addEventType(dataType.getPhysical().getName());
        }
        if (typed) {
            TypeEventFilterDefinition typeFilter = new TypeEventFilterDefinition(types);
            definition.addFilterDefinition((PhysicalEventFilterDefinition)typeFilter);
        }
        streams.add(definition);
        return streams;
    }

    private LogicalChannel getChannelInHierarchy(URI channelUri, LogicalInvocable invocable) throws GenerationException {
        LogicalChannel channel = null;
        for (LogicalCompositeComponent parent = (LogicalCompositeComponent)((LogicalComponent)invocable.getParent()).getParent(); parent != null && (channel = parent.getChannel(channelUri)) == null; parent = (LogicalCompositeComponent)parent.getParent()) {
        }
        if (channel == null) {
            throw new ChannelNotFoundException("Channel not found: " + channelUri);
        }
        return channel;
    }

    private <C extends LogicalComponent<?>> ComponentGenerator<C> getGenerator(C component) throws GeneratorNotFoundException {
        Implementation implementation = component.getDefinition().getImplementation();
        return this.generatorRegistry.getComponentGenerator(implementation.getClass());
    }

    private <T extends BindingDefinition> ConnectionBindingGenerator<T> getGenerator(LogicalBinding<T> binding) throws GeneratorNotFoundException {
        return this.generatorRegistry.getConnectionBindingGenerator(binding.getDefinition().getClass());
    }
}

