/*
 * Decompiled with CFR 0.152.
 */
package org.fabric3.fabric.generator.channel;

import java.util.List;
import org.fabric3.fabric.command.AttachChannelConnectionCommand;
import org.fabric3.fabric.command.ChannelConnectionCommand;
import org.fabric3.fabric.command.DetachChannelConnectionCommand;
import org.fabric3.fabric.generator.CommandGenerator;
import org.fabric3.fabric.generator.channel.ConnectionGenerator;
import org.fabric3.spi.generator.GenerationException;
import org.fabric3.spi.model.instance.LogicalComponent;
import org.fabric3.spi.model.instance.LogicalCompositeComponent;
import org.fabric3.spi.model.instance.LogicalConsumer;
import org.fabric3.spi.model.instance.LogicalState;
import org.fabric3.spi.model.physical.PhysicalChannelConnectionDefinition;
import org.oasisopen.sca.annotation.Property;
import org.oasisopen.sca.annotation.Reference;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ConsumerCommandGenerator
implements CommandGenerator {
    private ConnectionGenerator connectionGenerator;
    private int order;

    public ConsumerCommandGenerator(@Reference ConnectionGenerator connectionGenerator, @Property(name="order") int order) {
        this.connectionGenerator = connectionGenerator;
        this.order = order;
    }

    @Override
    public int getOrder() {
        return this.order;
    }

    @Override
    public ChannelConnectionCommand generate(LogicalComponent<?> component, boolean incremental) throws GenerationException {
        if (component instanceof LogicalCompositeComponent) {
            return null;
        }
        ChannelConnectionCommand command = new ChannelConnectionCommand();
        for (LogicalConsumer consumer : component.getConsumers()) {
            this.generateCommand(consumer, command, incremental);
        }
        if (command.getAttachCommands().isEmpty() && command.getDetachCommands().isEmpty()) {
            return null;
        }
        return command;
    }

    private void generateCommand(LogicalConsumer consumer, ChannelConnectionCommand command, boolean incremental) throws GenerationException {
        block3: {
            LogicalComponent component;
            block2: {
                component = (LogicalComponent)consumer.getParent();
                if (LogicalState.MARKED != component.getState()) break block2;
                List<PhysicalChannelConnectionDefinition> definitions = this.connectionGenerator.generateConsumer(consumer);
                for (PhysicalChannelConnectionDefinition definition : definitions) {
                    DetachChannelConnectionCommand channelConnectionCommand = new DetachChannelConnectionCommand(definition);
                    command.add(channelConnectionCommand);
                }
                break block3;
            }
            if (LogicalState.NEW != component.getState() && incremental) break block3;
            List<PhysicalChannelConnectionDefinition> definitions = this.connectionGenerator.generateConsumer(consumer);
            for (PhysicalChannelConnectionDefinition definition : definitions) {
                AttachChannelConnectionCommand channelConnectionCommand = new AttachChannelConnectionCommand(definition);
                command.add(channelConnectionCommand);
            }
        }
    }
}

