/*
 * Decompiled with CFR 0.152.
 */
package org.fabric3.fabric.generator.channel;

import java.net.URI;
import java.util.ArrayList;
import java.util.List;
import javax.xml.namespace.QName;
import org.fabric3.fabric.command.DisposeChannelsCommand;
import org.fabric3.fabric.generator.CommandGenerator;
import org.fabric3.spi.channel.ChannelIntents;
import org.fabric3.spi.generator.GenerationException;
import org.fabric3.spi.model.instance.LogicalChannel;
import org.fabric3.spi.model.instance.LogicalComponent;
import org.fabric3.spi.model.instance.LogicalCompositeComponent;
import org.fabric3.spi.model.instance.LogicalState;
import org.fabric3.spi.model.physical.PhysicalChannelDefinition;
import org.oasisopen.sca.annotation.EagerInit;
import org.oasisopen.sca.annotation.Property;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@EagerInit
public class DisposeChannelCommandGenerator
implements CommandGenerator {
    private int order;

    public DisposeChannelCommandGenerator(@Property(name="order") int order) {
        this.order = order;
    }

    @Override
    public int getOrder() {
        return this.order;
    }

    @Override
    public DisposeChannelsCommand generate(LogicalComponent<?> component, boolean incremental) throws GenerationException {
        if (!(component instanceof LogicalCompositeComponent)) {
            return null;
        }
        LogicalCompositeComponent composite = (LogicalCompositeComponent)component;
        List<PhysicalChannelDefinition> definitions = this.createDefinitions(composite);
        if (definitions.isEmpty()) {
            return null;
        }
        return new DisposeChannelsCommand(definitions);
    }

    private List<PhysicalChannelDefinition> createDefinitions(LogicalCompositeComponent composite) {
        ArrayList<PhysicalChannelDefinition> definitions = new ArrayList<PhysicalChannelDefinition>();
        for (LogicalChannel channel : composite.getChannels()) {
            if (channel.getState() != LogicalState.MARKED) continue;
            URI uri = channel.getUri();
            QName deployable = channel.getDeployable();
            boolean sync = channel.getDefinition().getIntents().contains(ChannelIntents.SYNC_INTENT);
            boolean replicating = channel.getDefinition().getIntents().contains(ChannelIntents.REPLICATE_INTENT);
            PhysicalChannelDefinition definition = new PhysicalChannelDefinition(uri, deployable, sync, replicating);
            definitions.add(definition);
        }
        return definitions;
    }
}

