/*
 * Decompiled with CFR 0.152.
 */
package org.fabric3.fabric.generator.channel;

import java.net.URI;
import java.util.ArrayList;
import java.util.List;
import javax.xml.namespace.QName;
import org.fabric3.fabric.command.BuildChannelsCommand;
import org.fabric3.fabric.command.DisposeChannelsCommand;
import org.fabric3.fabric.generator.GeneratorNotFoundException;
import org.fabric3.fabric.generator.GeneratorRegistry;
import org.fabric3.fabric.generator.channel.DomainChannelCommandGenerator;
import org.fabric3.model.type.component.BindingDefinition;
import org.fabric3.spi.channel.ChannelIntents;
import org.fabric3.spi.generator.ConnectionBindingGenerator;
import org.fabric3.spi.generator.GenerationException;
import org.fabric3.spi.model.instance.LogicalBinding;
import org.fabric3.spi.model.instance.LogicalChannel;
import org.fabric3.spi.model.instance.LogicalState;
import org.fabric3.spi.model.physical.PhysicalChannelBindingDefinition;
import org.fabric3.spi.model.physical.PhysicalChannelDefinition;
import org.oasisopen.sca.annotation.EagerInit;
import org.oasisopen.sca.annotation.Reference;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@EagerInit
public class DomainChannelCommandGeneratorImpl
implements DomainChannelCommandGenerator {
    private GeneratorRegistry generatorRegistry;

    public DomainChannelCommandGeneratorImpl(@Reference GeneratorRegistry generatorRegistry) {
        this.generatorRegistry = generatorRegistry;
    }

    @Override
    public BuildChannelsCommand generateBuild(LogicalChannel channel, boolean incremental) throws GenerationException {
        List<PhysicalChannelDefinition> definitions = this.createBuildDefinitions(channel, incremental);
        if (definitions.isEmpty()) {
            return null;
        }
        return new BuildChannelsCommand(definitions);
    }

    @Override
    public DisposeChannelsCommand generateDispose(LogicalChannel channel, boolean incremental) throws GenerationException {
        List<PhysicalChannelDefinition> definitions = this.createDisposeDefinitions(channel);
        if (definitions.isEmpty()) {
            return null;
        }
        return new DisposeChannelsCommand(definitions);
    }

    private List<PhysicalChannelDefinition> createBuildDefinitions(LogicalChannel channel, boolean incremental) throws GenerationException {
        ArrayList<PhysicalChannelDefinition> definitions = new ArrayList<PhysicalChannelDefinition>();
        if (channel.getState() == LogicalState.NEW || !incremental) {
            this.generateChannelDefinition(channel, definitions);
        }
        return definitions;
    }

    private List<PhysicalChannelDefinition> createDisposeDefinitions(LogicalChannel channel) throws GenerationException {
        ArrayList<PhysicalChannelDefinition> definitions = new ArrayList<PhysicalChannelDefinition>();
        if (channel.getState() == LogicalState.MARKED) {
            this.generateChannelDefinition(channel, definitions);
        }
        return definitions;
    }

    private void generateChannelDefinition(LogicalChannel channel, List<PhysicalChannelDefinition> definitions) throws GenerationException {
        URI uri = channel.getUri();
        QName deployable = channel.getDeployable();
        boolean sync = channel.getDefinition().getIntents().contains(ChannelIntents.SYNC_INTENT);
        boolean replicate = channel.getDefinition().getIntents().contains(ChannelIntents.REPLICATE_INTENT);
        PhysicalChannelDefinition definition = new PhysicalChannelDefinition(uri, deployable, sync, replicate);
        if (!channel.getBindings().isEmpty()) {
            LogicalBinding binding = channel.getBinding();
            ConnectionBindingGenerator bindingGenerator = this.getGenerator(binding);
            PhysicalChannelBindingDefinition bindingDefinition = bindingGenerator.generateChannelBinding(binding);
            definition.setBindingDefinition(bindingDefinition);
        }
        definitions.add(definition);
    }

    private <T extends BindingDefinition> ConnectionBindingGenerator<T> getGenerator(LogicalBinding<T> binding) throws GeneratorNotFoundException {
        return this.generatorRegistry.getConnectionBindingGenerator(binding.getDefinition().getClass());
    }
}

