/*
 * Decompiled with CFR 0.152.
 */
package org.fabric3.fabric.generator.component;

import java.net.URI;
import javax.xml.namespace.QName;
import org.fabric3.fabric.generator.CommandGenerator;
import org.fabric3.fabric.generator.GeneratorNotFoundException;
import org.fabric3.fabric.generator.GeneratorRegistry;
import org.fabric3.model.type.component.Implementation;
import org.fabric3.spi.generator.ComponentGenerator;
import org.fabric3.spi.generator.GenerationException;
import org.fabric3.spi.model.instance.LogicalComponent;
import org.fabric3.spi.model.physical.PhysicalComponentDefinition;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractBuildComponentCommandGenerator
implements CommandGenerator {
    private GeneratorRegistry generatorRegistry;

    public AbstractBuildComponentCommandGenerator(GeneratorRegistry generatorRegistry) {
        this.generatorRegistry = generatorRegistry;
    }

    protected PhysicalComponentDefinition generateDefinition(LogicalComponent<?> component) throws GenerationException {
        Implementation implementation = component.getDefinition().getImplementation();
        Class<?> type = implementation.getClass();
        ComponentGenerator<LogicalComponent<?>> generator = this.generatorRegistry.getComponentGenerator(type);
        if (generator == null) {
            throw new GeneratorNotFoundException(type);
        }
        PhysicalComponentDefinition definition = generator.generate(component);
        URI uri = component.getUri();
        definition.setComponentUri(uri);
        definition.setClassLoaderId(component.getDefinition().getContributionUri());
        QName deployable = component.getDeployable();
        definition.setDeployable(deployable);
        return definition;
    }
}

