/*
 * Decompiled with CFR 0.152.
 */
package org.fabric3.fabric.generator.resource;

import java.util.ArrayList;
import org.fabric3.fabric.command.BuildResourcesCommand;
import org.fabric3.fabric.generator.CommandGenerator;
import org.fabric3.fabric.generator.GeneratorRegistry;
import org.fabric3.model.type.component.ResourceDefinition;
import org.fabric3.spi.generator.GenerationException;
import org.fabric3.spi.generator.ResourceGenerator;
import org.fabric3.spi.model.instance.LogicalComponent;
import org.fabric3.spi.model.instance.LogicalCompositeComponent;
import org.fabric3.spi.model.instance.LogicalResource;
import org.fabric3.spi.model.instance.LogicalState;
import org.fabric3.spi.model.physical.PhysicalResourceDefinition;
import org.oasisopen.sca.annotation.Property;
import org.oasisopen.sca.annotation.Reference;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BuildResourceCommandGenerator
implements CommandGenerator {
    private GeneratorRegistry generatorRegistry;
    private int order;

    public BuildResourceCommandGenerator(@Reference GeneratorRegistry generatorRegistry, @Property(name="order") int order) {
        this.generatorRegistry = generatorRegistry;
        this.order = order;
    }

    @Override
    public int getOrder() {
        return this.order;
    }

    @Override
    public BuildResourcesCommand generate(LogicalComponent<?> component, boolean incremental) throws GenerationException {
        if (!(component instanceof LogicalCompositeComponent) || component.getState() != LogicalState.NEW && incremental) {
            return null;
        }
        LogicalCompositeComponent composite = (LogicalCompositeComponent)component;
        if (composite.getResources().isEmpty()) {
            return null;
        }
        ArrayList<PhysicalResourceDefinition> definitions = new ArrayList<PhysicalResourceDefinition>();
        for (LogicalResource resource : composite.getResources()) {
            ResourceDefinition resourceDefinition = resource.getDefinition();
            ResourceGenerator<?> generator = this.generatorRegistry.getResourceGenerator(resourceDefinition.getClass());
            PhysicalResourceDefinition definition = generator.generateResource(resource);
            definitions.add(definition);
        }
        if (definitions.isEmpty()) {
            return null;
        }
        return new BuildResourcesCommand(definitions);
    }
}

