/*
 * Decompiled with CFR 0.152.
 */
package org.fabric3.fabric.generator.wire;

import java.net.URI;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import javax.xml.namespace.QName;
import org.fabric3.fabric.generator.GeneratorRegistry;
import org.fabric3.fabric.generator.wire.PhysicalOperationGenerator;
import org.fabric3.model.type.contract.DataType;
import org.fabric3.model.type.contract.Operation;
import org.fabric3.model.type.definitions.PolicySet;
import org.fabric3.spi.contract.OperationNotFoundException;
import org.fabric3.spi.contract.OperationResolver;
import org.fabric3.spi.generator.GenerationException;
import org.fabric3.spi.generator.InterceptorGenerator;
import org.fabric3.spi.generator.PolicyMetadata;
import org.fabric3.spi.generator.policy.PolicyResult;
import org.fabric3.spi.model.instance.LogicalAttachPoint;
import org.fabric3.spi.model.instance.LogicalComponent;
import org.fabric3.spi.model.instance.LogicalOperation;
import org.fabric3.spi.model.physical.PhysicalInterceptorDefinition;
import org.fabric3.spi.model.physical.PhysicalOperationDefinition;
import org.oasisopen.sca.annotation.Property;
import org.oasisopen.sca.annotation.Reference;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PhysicalOperationGeneratorImpl
implements PhysicalOperationGenerator {
    private static final QName OASIS_ONEWAY = new QName("http://docs.oasis-open.org/ns/opencsa/sca/200912", "oneWay");
    private static final QName ALLOWS_BY_REFERENCE = new QName("urn:fabric3.org", "allowsPassByReference");
    private OperationResolver operationResolver;
    private GeneratorRegistry generatorRegistry;
    private boolean passByValueEnabled = false;

    public PhysicalOperationGeneratorImpl(@Reference OperationResolver operationResolver, @Reference GeneratorRegistry generatorRegistry) {
        this.operationResolver = operationResolver;
        this.generatorRegistry = generatorRegistry;
    }

    @Property(required=false)
    public void setPassByValueEnabled(boolean passByValueEnabled) {
        this.passByValueEnabled = passByValueEnabled;
    }

    @Override
    public Set<PhysicalOperationDefinition> generateOperations(List<LogicalOperation> operations, boolean remote, PolicyResult policyResult) throws GenerationException {
        HashSet<PhysicalOperationDefinition> physicalOperations = new HashSet<PhysicalOperationDefinition>(operations.size());
        Set endpointPolicySets = policyResult != null ? policyResult.getInterceptedEndpointPolicySets() : Collections.emptySet();
        for (LogicalOperation operation : operations) {
            PhysicalOperationDefinition physicalOperation = this.generate(operation, remote);
            if (policyResult != null) {
                List policies = policyResult.getInterceptedPolicySets(operation);
                ArrayList<PolicySet> allPolicies = new ArrayList<PolicySet>(endpointPolicySets);
                for (PolicySet policy : policies) {
                    if (allPolicies.contains(policy)) continue;
                    allPolicies.add(policy);
                }
                PolicyMetadata metadata = policyResult.getMetadata(operation);
                Set<PhysicalInterceptorDefinition> interceptors = this.generateInterceptors(operation, allPolicies, metadata);
                physicalOperation.setInterceptors(interceptors);
            }
            physicalOperations.add(physicalOperation);
        }
        return physicalOperations;
    }

    @Override
    public Set<PhysicalOperationDefinition> generateOperations(List<LogicalOperation> sources, List<LogicalOperation> targets, boolean remote, PolicyResult result) throws GenerationException {
        HashSet<PhysicalOperationDefinition> physicalOperations = new HashSet<PhysicalOperationDefinition>(sources.size());
        Set endpointPolicySets = result != null ? result.getInterceptedEndpointPolicySets() : Collections.emptySet();
        for (LogicalOperation source : sources) {
            LogicalOperation target;
            try {
                target = this.operationResolver.resolve(source, targets);
            }
            catch (OperationNotFoundException e) {
                throw new GenerationException((Throwable)e);
            }
            PhysicalOperationDefinition physicalOperation = this.generate(source, target, remote);
            if (result != null) {
                List policies = result.getInterceptedPolicySets(source);
                ArrayList<PolicySet> allPolicies = new ArrayList<PolicySet>(endpointPolicySets);
                allPolicies.addAll(policies);
                PolicyMetadata metadata = result.getMetadata(source);
                Set<PhysicalInterceptorDefinition> interceptors = this.generateInterceptors(source, allPolicies, metadata);
                physicalOperation.setInterceptors(interceptors);
            }
            physicalOperations.add(physicalOperation);
        }
        return physicalOperations;
    }

    private Set<PhysicalInterceptorDefinition> generateInterceptors(LogicalOperation operation, List<PolicySet> policies, PolicyMetadata metadata) throws GenerationException {
        if (policies == null) {
            return Collections.emptySet();
        }
        LinkedHashSet<PhysicalInterceptorDefinition> interceptors = new LinkedHashSet<PhysicalInterceptorDefinition>();
        for (PolicySet policy : policies) {
            QName expressionName = policy.getExpressionName();
            InterceptorGenerator generator = this.generatorRegistry.getInterceptorGenerator(expressionName);
            PhysicalInterceptorDefinition pid = generator.generate(policy.getExpression(), metadata, operation);
            if (pid == null) continue;
            URI contributionClassLoaderId = ((LogicalComponent)((LogicalAttachPoint)operation.getParent()).getParent()).getDefinition().getContributionUri();
            pid.setWireClassLoaderId(contributionClassLoaderId);
            pid.setPolicyClassLoaderId(policy.getContributionUri());
            interceptors.add(pid);
        }
        return interceptors;
    }

    private PhysicalOperationDefinition generate(LogicalOperation source, boolean remote) {
        Operation o = source.getDefinition();
        PhysicalOperationDefinition operation = new PhysicalOperationDefinition();
        operation.setName(o.getName());
        if (o.getIntents().contains(OASIS_ONEWAY)) {
            operation.setOneWay(true);
        }
        boolean remotable = o.isRemotable();
        operation.setRemotable(remotable);
        if (remotable && !this.useByReference(source, remote)) {
            operation.setAllowsPassByReference(false);
        }
        Class returnType = o.getOutputType().getPhysical();
        String returnName = returnType.getName();
        operation.setSourceReturnType(returnName);
        operation.setTargetReturnType(returnName);
        for (DataType fault : o.getFaultTypes()) {
            Class faultType = fault.getPhysical();
            String faultName = faultType.getName();
            operation.addSourceFaultType(faultName);
            operation.addTargetFaultType(faultName);
        }
        List params = o.getInputTypes();
        for (DataType param : params) {
            Class paramType = param.getPhysical();
            String paramName = paramType.getName();
            operation.addSourceParameterType(paramName);
            operation.addTargetParameterType(paramName);
        }
        return operation;
    }

    private PhysicalOperationDefinition generate(LogicalOperation source, LogicalOperation target, boolean remote) {
        Operation o = source.getDefinition();
        PhysicalOperationDefinition operation = new PhysicalOperationDefinition();
        operation.setName(o.getName());
        boolean remotable = o.isRemotable();
        operation.setRemotable(remotable);
        if (!(!remotable || this.useByReference(source, remote) && this.useByReference(target, remote))) {
            operation.setAllowsPassByReference(false);
        }
        if (o.getIntents().contains(OASIS_ONEWAY)) {
            operation.setOneWay(true);
        }
        Class returnType = o.getOutputType().getPhysical();
        operation.setSourceReturnType(returnType.getName());
        for (DataType fault : o.getFaultTypes()) {
            Class faultType = fault.getPhysical();
            operation.addSourceFaultType(faultType.getName());
        }
        List params = o.getInputTypes();
        for (DataType param : params) {
            Class paramType = param.getPhysical();
            operation.addSourceParameterType(paramType.getName());
        }
        Operation targetDefinition = target.getDefinition();
        Class targetReturnType = targetDefinition.getOutputType().getPhysical();
        operation.setTargetReturnType(targetReturnType.getName());
        for (DataType targetFault : targetDefinition.getFaultTypes()) {
            Class faultType = targetFault.getPhysical();
            operation.addTargetFaultType(faultType.getName());
        }
        List targetParams = targetDefinition.getInputTypes();
        for (DataType param : targetParams) {
            Class paramType = param.getPhysical();
            operation.addTargetParameterType(paramType.getName());
        }
        return operation;
    }

    private boolean useByReference(LogicalOperation operation, boolean remote) {
        if (!this.passByValueEnabled || remote) {
            return true;
        }
        LogicalAttachPoint logicalAttachPoint = (LogicalAttachPoint)operation.getParent();
        LogicalComponent component = (LogicalComponent)logicalAttachPoint.getParent();
        return operation.getIntents().contains(ALLOWS_BY_REFERENCE) || logicalAttachPoint.getIntents().contains(ALLOWS_BY_REFERENCE) || component.getIntents().contains(ALLOWS_BY_REFERENCE) || component.getDefinition().getImplementation().getIntents().contains(ALLOWS_BY_REFERENCE) || component.getDefinition().getImplementation().getComponentType().getIntents().contains(ALLOWS_BY_REFERENCE);
    }
}

