/*
 * Decompiled with CFR 0.152.
 */
package org.fabric3.fabric.host;

import java.io.IOException;
import java.io.Serializable;
import java.net.DatagramSocket;
import java.net.ServerSocket;
import org.fabric3.spi.host.Port;

public class PortImpl
implements Port,
Serializable {
    private static final long serialVersionUID = -708646870372177434L;
    private String name;
    private int number;
    private transient ServerSocket serverSocket;
    private transient DatagramSocket datagramSocket;

    public PortImpl(String name, int number, ServerSocket serverSocket, DatagramSocket datagramSocket) {
        this.name = name;
        this.number = number;
        this.serverSocket = serverSocket;
        this.datagramSocket = datagramSocket;
    }

    public String getName() {
        return this.name;
    }

    public int getNumber() {
        return this.number;
    }

    public void bind(Port.TYPE type) {
        if (Port.TYPE.TCP == type) {
            try {
                if (this.serverSocket == null || this.serverSocket.isClosed()) {
                    return;
                }
                this.serverSocket.close();
                this.serverSocket = null;
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        } else {
            if (this.datagramSocket == null || this.datagramSocket.isClosed()) {
                return;
            }
            this.datagramSocket.close();
            this.datagramSocket = null;
        }
    }

    public void release() {
        this.bind(Port.TYPE.TCP);
        this.bind(Port.TYPE.UDP);
    }
}

