/*
 * Decompiled with CFR 0.152.
 */
package org.fabric3.fabric.instantiator;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.xml.namespace.QName;
import org.fabric3.fabric.instantiator.AtomicComponentInstantiator;
import org.fabric3.fabric.instantiator.AutowireInstantiator;
import org.fabric3.fabric.instantiator.AutowireNormalizer;
import org.fabric3.fabric.instantiator.ChannelInstantiator;
import org.fabric3.fabric.instantiator.CompositeComponentInstantiator;
import org.fabric3.fabric.instantiator.DuplicateProperty;
import org.fabric3.fabric.instantiator.InstantiationContext;
import org.fabric3.fabric.instantiator.LogicalModelInstantiator;
import org.fabric3.fabric.instantiator.PromotionNormalizer;
import org.fabric3.fabric.instantiator.PromotionResolutionService;
import org.fabric3.fabric.instantiator.WireInstantiator;
import org.fabric3.model.type.component.ComponentDefinition;
import org.fabric3.model.type.component.Composite;
import org.fabric3.model.type.component.CompositeImplementation;
import org.fabric3.model.type.component.Include;
import org.fabric3.model.type.component.Property;
import org.fabric3.model.type.component.ResourceDefinition;
import org.fabric3.spi.model.instance.LogicalChannel;
import org.fabric3.spi.model.instance.LogicalComponent;
import org.fabric3.spi.model.instance.LogicalCompositeComponent;
import org.fabric3.spi.model.instance.LogicalProperty;
import org.fabric3.spi.model.instance.LogicalResource;
import org.oasisopen.sca.annotation.Reference;
import org.w3c.dom.Document;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LogicalModelInstantiatorImpl
implements LogicalModelInstantiator {
    private static final QName SYNTHETIC_COMPOSITE = new QName("urn:fabric3.org", "SyntheticComposite");
    private ChannelInstantiator channelInstantiator;
    private PromotionNormalizer promotionNormalizer;
    private AtomicComponentInstantiator atomicComponentInstantiator;
    private CompositeComponentInstantiator compositeComponentInstantiator;
    private WireInstantiator wireInstantiator;
    private AutowireNormalizer autowireNormalizer;
    private PromotionResolutionService promotionResolutionService;
    private AutowireInstantiator autowireInstantiator;

    public LogicalModelInstantiatorImpl(@Reference CompositeComponentInstantiator compositeComponentInstantiator, @Reference AtomicComponentInstantiator atomicComponentInstantiator, @Reference WireInstantiator wireInstantiator, @Reference AutowireInstantiator autowireInstantiator, @Reference ChannelInstantiator channelInstantiator, @Reference PromotionNormalizer promotionNormalizer, @Reference AutowireNormalizer autowireNormalizer, @Reference PromotionResolutionService promotionResolutionService) {
        this.channelInstantiator = channelInstantiator;
        this.promotionNormalizer = promotionNormalizer;
        this.atomicComponentInstantiator = atomicComponentInstantiator;
        this.compositeComponentInstantiator = compositeComponentInstantiator;
        this.wireInstantiator = wireInstantiator;
        this.autowireNormalizer = autowireNormalizer;
        this.promotionResolutionService = promotionResolutionService;
        this.autowireInstantiator = autowireInstantiator;
    }

    @Override
    public InstantiationContext include(Composite composite, LogicalCompositeComponent domain) {
        return this.include(domain, composite, false);
    }

    @Override
    public InstantiationContext include(List<Composite> composites, LogicalCompositeComponent domain) {
        Composite composite = this.synthesizeComposite(composites);
        return this.include(domain, composite, true);
    }

    private InstantiationContext include(LogicalCompositeComponent domain, Composite composite, boolean synthetic) {
        InstantiationContext context = new InstantiationContext();
        this.includeProperties(composite, domain, context);
        this.includeResources(composite, domain, synthetic);
        List<LogicalComponent<?>> newComponents = this.instantiate(composite, domain, synthetic, context);
        for (LogicalComponent<?> logicalComponent : newComponents) {
            this.normalize(logicalComponent, context);
        }
        for (LogicalComponent logicalComponent : domain.getComponents()) {
            this.promotionResolutionService.resolve(logicalComponent, context);
            this.autowireInstantiator.instantiate(logicalComponent, context);
        }
        return context;
    }

    private void includeProperties(Composite composite, LogicalCompositeComponent domain, InstantiationContext context) {
        for (Property property : composite.getProperties().values()) {
            String name = property.getName();
            if (domain.getAllProperties().containsKey(name)) {
                DuplicateProperty error = new DuplicateProperty(name, domain);
                context.addError(error);
                continue;
            }
            Document value = property.getDefaultValue();
            boolean many = property.isMany();
            QName type = property.getType();
            LogicalProperty logicalProperty = new LogicalProperty(name, value, many, type, (LogicalComponent)domain);
            domain.setProperties(logicalProperty);
        }
    }

    private void includeResources(Composite composite, LogicalCompositeComponent domain, boolean synthetic) {
        if (synthetic) {
            for (Include include : composite.getIncludes().values()) {
                Composite included = include.getIncluded();
                for (ResourceDefinition definition : included.getResources()) {
                    LogicalResource resource = new LogicalResource(definition, domain);
                    resource.setDeployable(included.getName());
                    domain.addResource(resource);
                }
            }
        } else {
            for (ResourceDefinition definition : composite.getResources()) {
                LogicalResource resource = new LogicalResource(definition, domain);
                resource.setDeployable(composite.getName());
                domain.addResource(resource);
            }
        }
    }

    private List<LogicalComponent<?>> instantiate(Composite composite, LogicalCompositeComponent domain, boolean synthetic, InstantiationContext context) {
        Collection definitions = composite.getDeclaredComponents().values();
        ArrayList newComponents = new ArrayList(definitions.size());
        for (ComponentDefinition componentDefinition : definitions) {
            LogicalComponent<?> logicalComponent = this.instantiate(componentDefinition, domain, context);
            this.setDeployable(logicalComponent, composite.getName());
            newComponents.add(logicalComponent);
        }
        this.instantiateIncludes(composite, newComponents, synthetic, domain, context);
        this.wireInstantiator.instantiateCompositeWires(composite, domain, context);
        for (LogicalComponent logicalComponent : newComponents) {
            this.wireInstantiator.instantiateReferenceWires(logicalComponent, context);
        }
        if (synthetic) {
            for (Include include : composite.getIncludes().values()) {
                Composite included = include.getIncluded();
                this.channelInstantiator.instantiateChannels(included, domain, context);
            }
        } else {
            this.channelInstantiator.instantiateChannels(composite, domain, context);
        }
        return newComponents;
    }

    private LogicalComponent<?> instantiate(ComponentDefinition<?> definition, LogicalCompositeComponent parent, InstantiationContext context) {
        if (definition.getImplementation() instanceof CompositeImplementation) {
            ComponentDefinition<?> componentDefinition = definition;
            return this.compositeComponentInstantiator.instantiate(componentDefinition, parent, context);
        }
        ComponentDefinition<?> componentDefinition = definition;
        return this.atomicComponentInstantiator.instantiate(componentDefinition, parent, context);
    }

    private void instantiateIncludes(Composite composite, List<LogicalComponent<?>> newComponents, boolean synthetic, LogicalCompositeComponent domain, InstantiationContext context) {
        for (Include include : composite.getIncludes().values()) {
            for (ComponentDefinition definition : include.getIncluded().getComponents().values()) {
                LogicalComponent<?> logicalComponent = this.instantiate(definition, domain, context);
                if (synthetic) {
                    this.setDeployable(logicalComponent, include.getIncluded().getName());
                } else {
                    this.setDeployable(logicalComponent, composite.getName());
                }
                newComponents.add(logicalComponent);
                domain.addComponent(logicalComponent);
            }
        }
    }

    private void normalize(LogicalComponent<?> component, InstantiationContext context) {
        this.autowireNormalizer.normalize(component);
        if (component instanceof LogicalCompositeComponent) {
            LogicalCompositeComponent composite = (LogicalCompositeComponent)component;
            for (LogicalComponent child : composite.getComponents()) {
                this.normalize(child, context);
            }
        } else {
            this.promotionNormalizer.normalize(component, context);
        }
    }

    private Composite synthesizeComposite(List<Composite> composites) {
        Composite synthesized = new Composite(SYNTHETIC_COMPOSITE);
        for (Composite composite : composites) {
            Include include = new Include();
            include.setName(composite.getName());
            include.setIncluded(composite);
            synthesized.add(include);
        }
        return synthesized;
    }

    private void setDeployable(LogicalComponent<?> component, QName deployable) {
        if (component instanceof LogicalCompositeComponent) {
            LogicalCompositeComponent composite = (LogicalCompositeComponent)component;
            for (LogicalComponent child : composite.getComponents()) {
                this.setDeployable(child, deployable);
            }
            for (LogicalResource resource : composite.getResources()) {
                resource.setDeployable(deployable);
            }
            for (LogicalChannel channel : composite.getChannels()) {
                channel.setDeployable(deployable);
            }
        }
        component.setDeployable(deployable);
    }
}

