/*
 * Decompiled with CFR 0.152.
 */
package org.fabric3.fabric.instantiator.channel;

import java.net.URI;
import org.fabric3.fabric.instantiator.ChannelInstantiator;
import org.fabric3.fabric.instantiator.InstantiationContext;
import org.fabric3.fabric.instantiator.channel.DuplicateChannel;
import org.fabric3.model.type.component.BindingDefinition;
import org.fabric3.model.type.component.ChannelDefinition;
import org.fabric3.model.type.component.Composite;
import org.fabric3.spi.model.instance.Bindable;
import org.fabric3.spi.model.instance.LogicalBinding;
import org.fabric3.spi.model.instance.LogicalChannel;
import org.fabric3.spi.model.instance.LogicalCompositeComponent;

public class ChannelInstantiatorImpl
implements ChannelInstantiator {
    public void instantiateChannels(Composite composite, LogicalCompositeComponent parent, InstantiationContext context) {
        for (ChannelDefinition definition : composite.getChannels().values()) {
            URI uri = URI.create(parent.getUri() + "/" + definition.getName());
            if (parent.getChannel(uri) != null) {
                DuplicateChannel error = new DuplicateChannel(uri, parent);
                context.addError(error);
                continue;
            }
            LogicalChannel channel = new LogicalChannel(uri, definition, parent);
            for (BindingDefinition binding : definition.getBindings()) {
                LogicalBinding logicalBinding = new LogicalBinding(binding, (Bindable)channel);
                channel.addBinding(logicalBinding);
            }
            channel.setDeployable(composite.getName());
            parent.addChannel(channel);
        }
    }
}

