/*
 * Decompiled with CFR 0.152.
 */
package org.fabric3.fabric.instantiator.component;

import java.io.IOException;
import java.net.URI;
import java.util.Map;
import javax.xml.namespace.NamespaceContext;
import javax.xml.namespace.QName;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import javax.xml.xpath.XPathVariableResolver;
import org.fabric3.fabric.instantiator.InstantiationContext;
import org.fabric3.fabric.instantiator.component.InvalidProperty;
import org.fabric3.fabric.instantiator.component.InvalidPropertyFile;
import org.fabric3.fabric.instantiator.component.NamespaceHelper;
import org.fabric3.fabric.instantiator.component.PropertySourceNotFound;
import org.fabric3.fabric.instantiator.component.PropertyTypeException;
import org.fabric3.model.type.component.ComponentDefinition;
import org.fabric3.model.type.component.ComponentType;
import org.fabric3.model.type.component.Property;
import org.fabric3.model.type.component.PropertyValue;
import org.fabric3.spi.model.instance.LogicalComponent;
import org.fabric3.spi.model.instance.LogicalCompositeComponent;
import org.fabric3.spi.model.instance.LogicalProperty;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractComponentInstantiator {
    private static final DocumentBuilderFactory DOCUMENT_FACTORY = DocumentBuilderFactory.newInstance();
    private static final XPathFactory XPATH_FACTORY;

    protected void initializeProperties(LogicalComponent<?> component, ComponentDefinition<?> definition, InstantiationContext context) {
        Map propertyValues = definition.getPropertyValues();
        ComponentType componentType = definition.getComponentType();
        LogicalCompositeComponent parent = (LogicalCompositeComponent)component.getParent();
        for (Property property : componentType.getProperties().values()) {
            Document value;
            String name = property.getName();
            PropertyValue propertyValue = (PropertyValue)propertyValues.get(name);
            if (propertyValue == null) {
                value = property.getDefaultValue();
            } else if (propertyValue.getFile() != null) {
                value = this.loadValueFromFile(property.getName(), propertyValue.getFile(), component, context);
            } else if (propertyValue.getSource() != null) {
                try {
                    NamespaceContext nsContext = propertyValue.getNamespaceContext();
                    value = this.deriveValueFromXPath(propertyValue, (LogicalComponent<?>)parent, nsContext);
                }
                catch (PropertyTypeException e) {
                    InvalidProperty error = new InvalidProperty(name, component, (Throwable)((Object)e));
                    context.addError(error);
                    return;
                }
            } else {
                value = propertyValue.getValue();
            }
            if (property.isRequired() && value == null) {
                PropertySourceNotFound error = new PropertySourceNotFound(name, component);
                context.addError(error);
                continue;
            }
            if (!property.isRequired() && value == null) continue;
            boolean many = property.isMany();
            QName type = property.getType();
            LogicalProperty logicalProperty = type == null ? new LogicalProperty(name, value, many, component) : new LogicalProperty(name, value, many, type, component);
            component.setProperties(logicalProperty);
        }
    }

    Document deriveValueFromXPath(final PropertyValue propertyValue, final LogicalComponent<?> parent, NamespaceContext nsContext) throws PropertyTypeException {
        DocumentBuilder builder;
        XPathVariableResolver variableResolver = new XPathVariableResolver(){

            public Object resolveVariable(QName qName) {
                String name = qName.getLocalPart();
                LogicalProperty property = parent.getProperties(name);
                if (property == null) {
                    return null;
                }
                if (propertyValue.getType() != null && property.getType() != null && !propertyValue.getType().equals(property.getType())) {
                    throw new PropertyTypeException("Property types are incompatible:" + name + " and " + propertyValue.getName());
                }
                Document value = property.getValue();
                if (value == null || value.getDocumentElement().getChildNodes().getLength() == 0) {
                    return null;
                }
                return value.getDocumentElement();
            }
        };
        XPath xpath = XPATH_FACTORY.newXPath();
        xpath.setXPathVariableResolver(variableResolver);
        xpath.setNamespaceContext(nsContext);
        try {
            builder = DOCUMENT_FACTORY.newDocumentBuilder();
        }
        catch (ParserConfigurationException e) {
            throw new AssertionError((Object)e);
        }
        Document document = builder.newDocument();
        Element root = document.createElement("values");
        document.appendChild(root);
        String source = propertyValue.getSource();
        try {
            source = this.parseSource(source);
            NodeList result = (NodeList)xpath.evaluate(source, document, XPathConstants.NODESET);
            if (result.getLength() == 0) {
                return null;
            }
            for (int i = 0; i < result.getLength(); ++i) {
                Element value;
                Node node = result.item(i);
                if (!"value".equals(node.getNodeName())) {
                    value = document.createElement("value");
                    root.appendChild(value);
                } else {
                    value = root;
                }
                Node cloned = node.cloneNode(true);
                NamespaceHelper.copyNamespaces(node, value);
                document.adoptNode(cloned);
                short type = cloned.getNodeType();
                if (1 == type || 3 == type) {
                    value.appendChild(cloned);
                    continue;
                }
                if (2 == type) {
                    Element element = document.createElement(cloned.getNodeName());
                    element.setTextContent(cloned.getNodeValue());
                    value.appendChild(element);
                    continue;
                }
                throw new XPathExpressionException("Unsupported node type: " + type);
            }
        }
        catch (XPathExpressionException e) {
            String message;
            if (e.getCause() instanceof TransformerException && ((message = e.getCause().getMessage()).startsWith("resolveVariable for variable") || message.endsWith("returning null"))) {
                return null;
            }
            throw new PropertyTypeException(e);
        }
        return document;
    }

    public Document loadValueFromFile(String name, URI fileUri, LogicalComponent<?> parent, InstantiationContext context) {
        try {
            DocumentBuilder builder = DOCUMENT_FACTORY.newDocumentBuilder();
            Document document = builder.parse(fileUri.toString());
            Element root = document.getDocumentElement();
            if (!"values".equals(root.getNodeName())) {
                if ("value".equals(root.getNodeName())) {
                    Element newRoot = document.createElement("values");
                    document.removeChild(root);
                    document.appendChild(newRoot);
                    newRoot.appendChild(root);
                } else {
                    Element newRoot = document.createElement("values");
                    document.removeChild(root);
                    document.appendChild(newRoot);
                    Element value = document.createElement("value");
                    newRoot.appendChild(value);
                    value.appendChild(root);
                }
            }
            return document;
        }
        catch (IOException e) {
            InvalidPropertyFile error = new InvalidPropertyFile(name, parent, e, fileUri);
            context.addError(error);
            return null;
        }
        catch (SAXException e) {
            InvalidPropertyFile error = new InvalidPropertyFile(name, parent, e, fileUri);
            context.addError(error);
            return null;
        }
        catch (ParserConfigurationException e) {
            throw new AssertionError((Object)e);
        }
    }

    private String parseSource(String source) {
        int index;
        if (source.startsWith("$") && (index = source.indexOf("/")) > 0 && index < source.length() - 2 && !source.substring(index + 1, index + 2).equals("/")) {
            source = source.substring(0, index) + "/" + source.substring(index);
        }
        return source;
    }

    static {
        DOCUMENT_FACTORY.setNamespaceAware(true);
        XPATH_FACTORY = XPathFactory.newInstance();
    }
}

