/*
 * Decompiled with CFR 0.152.
 */
package org.fabric3.fabric.instantiator.component;

import java.net.URI;
import org.fabric3.fabric.instantiator.AtomicComponentInstantiator;
import org.fabric3.fabric.instantiator.InstantiationContext;
import org.fabric3.fabric.instantiator.component.AbstractComponentInstantiator;
import org.fabric3.fabric.instantiator.component.DuplicateComponent;
import org.fabric3.model.type.component.BindingDefinition;
import org.fabric3.model.type.component.ComponentConsumer;
import org.fabric3.model.type.component.ComponentDefinition;
import org.fabric3.model.type.component.ComponentProducer;
import org.fabric3.model.type.component.ComponentReference;
import org.fabric3.model.type.component.ComponentService;
import org.fabric3.model.type.component.ComponentType;
import org.fabric3.model.type.component.ConsumerDefinition;
import org.fabric3.model.type.component.Implementation;
import org.fabric3.model.type.component.ProducerDefinition;
import org.fabric3.model.type.component.ReferenceDefinition;
import org.fabric3.model.type.component.ResourceReferenceDefinition;
import org.fabric3.model.type.component.ServiceDefinition;
import org.fabric3.spi.model.instance.Bindable;
import org.fabric3.spi.model.instance.LogicalBinding;
import org.fabric3.spi.model.instance.LogicalComponent;
import org.fabric3.spi.model.instance.LogicalCompositeComponent;
import org.fabric3.spi.model.instance.LogicalConsumer;
import org.fabric3.spi.model.instance.LogicalProducer;
import org.fabric3.spi.model.instance.LogicalReference;
import org.fabric3.spi.model.instance.LogicalResourceReference;
import org.fabric3.spi.model.instance.LogicalService;
import org.oasisopen.sca.annotation.Property;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AtomicComponentInstantiatorImpl
extends AbstractComponentInstantiator
implements AtomicComponentInstantiator {
    private boolean componentTypeOverride;

    @Property(required=false)
    public void setComponentTypeOverride(boolean componentTypeOverride) {
        this.componentTypeOverride = componentTypeOverride;
    }

    public LogicalComponent instantiate(ComponentDefinition<?> definition, LogicalCompositeComponent parent, InstantiationContext context) {
        URI uri = URI.create(parent.getUri() + "/" + definition.getName());
        LogicalComponent component = new LogicalComponent(uri, definition, parent);
        if (parent.getComponent(uri) != null) {
            DuplicateComponent error = new DuplicateComponent(uri, parent);
            context.addError(error);
        }
        parent.addComponent(component);
        Implementation impl = definition.getImplementation();
        if (impl == null) {
            return component;
        }
        ComponentType componentType = impl.getComponentType();
        if (this.componentTypeOverride) {
            component.getPolicySets().removeAll(definition.getPolicySets());
        }
        this.initializeProperties(component, definition, context);
        this.createServices(definition, component, componentType);
        this.createReferences(definition, component, componentType);
        this.createProducers(definition, component, componentType);
        this.createConsumers(definition, component, componentType);
        this.createResourceReferences(component, componentType);
        return component;
    }

    private void createServices(ComponentDefinition<?> definition, LogicalComponent<?> component, ComponentType componentType) {
        for (ServiceDefinition service : componentType.getServices().values()) {
            LogicalBinding logicalBinding;
            String name = service.getName();
            URI serviceUri = component.getUri().resolve('#' + name);
            LogicalService logicalService = new LogicalService(serviceUri, service, component);
            for (BindingDefinition binding : service.getBindings()) {
                logicalBinding = new LogicalBinding(binding, (Bindable)logicalService);
                logicalService.addBinding(logicalBinding);
            }
            for (BindingDefinition binding : service.getCallbackBindings()) {
                logicalBinding = new LogicalBinding(binding, (Bindable)logicalService);
                logicalService.addCallbackBinding(logicalBinding);
            }
            ComponentService componentService = (ComponentService)definition.getServices().get(name);
            if (componentService != null) {
                LogicalBinding logicalBinding2;
                logicalService.addIntents(componentService.getIntents());
                for (BindingDefinition binding : componentService.getBindings()) {
                    logicalBinding2 = new LogicalBinding(binding, (Bindable)logicalService);
                    logicalService.addBinding(logicalBinding2);
                }
                for (BindingDefinition binding : componentService.getCallbackBindings()) {
                    logicalBinding2 = new LogicalBinding(binding, (Bindable)logicalService);
                    logicalService.addCallbackBinding(logicalBinding2);
                }
            }
            component.addService(logicalService);
        }
    }

    private void createReferences(ComponentDefinition<?> definition, LogicalComponent<?> component, ComponentType componentType) {
        for (ReferenceDefinition reference : componentType.getReferences().values()) {
            String name = reference.getName();
            URI referenceUri = component.getUri().resolve('#' + name);
            LogicalReference logicalReference = new LogicalReference(referenceUri, reference, component);
            ComponentReference componentReference = (ComponentReference)definition.getReferences().get(name);
            if (componentReference != null) {
                LogicalBinding logicalBinding;
                logicalReference.addIntents(componentReference.getIntents());
                for (BindingDefinition binding : componentReference.getBindings()) {
                    logicalBinding = new LogicalBinding(binding, (Bindable)logicalReference);
                    logicalReference.addBinding(logicalBinding);
                }
                for (BindingDefinition binding : componentReference.getCallbackBindings()) {
                    logicalBinding = new LogicalBinding(binding, (Bindable)logicalReference);
                    logicalReference.addCallbackBinding(logicalBinding);
                }
            }
            component.addReference(logicalReference);
        }
    }

    private void createConsumers(ComponentDefinition<?> definition, LogicalComponent<?> component, ComponentType componentType) {
        for (ConsumerDefinition consumer : componentType.getConsumers().values()) {
            String name = consumer.getName();
            URI consumerUri = component.getUri().resolve('#' + name);
            LogicalConsumer logicalConsumer = new LogicalConsumer(consumerUri, consumer, component);
            ComponentConsumer componentConsumer = (ComponentConsumer)definition.getConsumers().get(name);
            if (componentConsumer != null) {
                logicalConsumer.addIntents(componentConsumer.getIntents());
                for (URI uri : componentConsumer.getSources()) {
                    logicalConsumer.addSource(URI.create(((LogicalCompositeComponent)component.getParent()).getUri().toString() + "/" + uri.toString()));
                }
            }
            component.addConsumer(logicalConsumer);
        }
    }

    private void createProducers(ComponentDefinition<?> definition, LogicalComponent<?> component, ComponentType componentType) {
        for (ProducerDefinition producer : componentType.getProducers().values()) {
            String name = producer.getName();
            URI producerUri = component.getUri().resolve('#' + name);
            LogicalProducer logicalProducer = new LogicalProducer(producerUri, producer, component);
            ComponentProducer componentProducer = (ComponentProducer)definition.getProducers().get(name);
            if (componentProducer != null) {
                logicalProducer.addIntents(componentProducer.getIntents());
                for (URI uri : componentProducer.getTargets()) {
                    logicalProducer.addTarget(URI.create(((LogicalCompositeComponent)component.getParent()).getUri().toString() + "/" + uri.toString()));
                }
            }
            component.addProducer(logicalProducer);
        }
    }

    private void createResourceReferences(LogicalComponent<?> component, ComponentType componentType) {
        for (ResourceReferenceDefinition resourceReference : componentType.getResourceReferences().values()) {
            URI resourceUri = component.getUri().resolve('#' + resourceReference.getName());
            LogicalResourceReference logicalResourceReference = new LogicalResourceReference(resourceUri, resourceReference, component);
            component.addResource(logicalResourceReference);
        }
    }
}

