/*
 * Decompiled with CFR 0.152.
 */
package org.fabric3.fabric.instantiator.component;

import java.net.URI;
import java.util.ArrayList;
import org.fabric3.fabric.instantiator.AtomicComponentInstantiator;
import org.fabric3.fabric.instantiator.ChannelInstantiator;
import org.fabric3.fabric.instantiator.CompositeComponentInstantiator;
import org.fabric3.fabric.instantiator.InstantiationContext;
import org.fabric3.fabric.instantiator.WireInstantiator;
import org.fabric3.fabric.instantiator.component.AbstractComponentInstantiator;
import org.fabric3.fabric.instantiator.component.DuplicateComponent;
import org.fabric3.model.type.component.BindingDefinition;
import org.fabric3.model.type.component.ComponentDefinition;
import org.fabric3.model.type.component.ComponentReference;
import org.fabric3.model.type.component.ComponentService;
import org.fabric3.model.type.component.Composite;
import org.fabric3.model.type.component.CompositeImplementation;
import org.fabric3.model.type.component.CompositeReference;
import org.fabric3.model.type.component.CompositeService;
import org.fabric3.model.type.component.ReferenceDefinition;
import org.fabric3.model.type.component.ResourceDefinition;
import org.fabric3.model.type.component.ServiceDefinition;
import org.fabric3.spi.model.instance.Bindable;
import org.fabric3.spi.model.instance.LogicalBinding;
import org.fabric3.spi.model.instance.LogicalComponent;
import org.fabric3.spi.model.instance.LogicalCompositeComponent;
import org.fabric3.spi.model.instance.LogicalReference;
import org.fabric3.spi.model.instance.LogicalResource;
import org.fabric3.spi.model.instance.LogicalService;
import org.oasisopen.sca.annotation.Property;
import org.oasisopen.sca.annotation.Reference;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CompositeComponentInstantiatorImpl
extends AbstractComponentInstantiator
implements CompositeComponentInstantiator {
    private AtomicComponentInstantiator atomicInstantiator;
    private WireInstantiator wireInstantiator;
    private ChannelInstantiator channelInstantiator;
    private boolean componentTypeOverride;

    @Property(required=false)
    public void setComponentTypeOverride(boolean componentTypeOverride) {
        this.componentTypeOverride = componentTypeOverride;
    }

    public CompositeComponentInstantiatorImpl(@Reference AtomicComponentInstantiator atomicInstantiator, @Reference WireInstantiator wireInstantiator, @Reference ChannelInstantiator channelInstantiator) {
        this.atomicInstantiator = atomicInstantiator;
        this.wireInstantiator = wireInstantiator;
        this.channelInstantiator = channelInstantiator;
    }

    public LogicalComponent<CompositeImplementation> instantiate(ComponentDefinition<CompositeImplementation> definition, LogicalCompositeComponent parent, InstantiationContext context) {
        URI uri = URI.create(parent.getUri() + "/" + definition.getName());
        Composite composite = (Composite)((CompositeImplementation)definition.getImplementation()).getComponentType();
        LogicalCompositeComponent component = new LogicalCompositeComponent(uri, definition, parent);
        if (this.componentTypeOverride) {
            component.getPolicySets().removeAll(definition.getPolicySets());
        }
        this.initializeProperties((LogicalComponent<?>)component, definition, context);
        this.instantiateChildComponents(component, composite, context);
        this.instantiateCompositeServices(component, composite);
        this.wireInstantiator.instantiateCompositeWires(composite, component, context);
        this.instantiateCompositeReferences(component, composite);
        this.instantiateResources(component, composite);
        this.wireInstantiator.instantiateCompositeWires(composite, component, context);
        this.channelInstantiator.instantiateChannels(composite, component, context);
        if (parent.getComponent(uri) != null) {
            DuplicateComponent error = new DuplicateComponent(uri, parent);
            context.addError(error);
        }
        parent.addComponent((LogicalComponent)component);
        return component;
    }

    private void instantiateChildComponents(LogicalCompositeComponent component, Composite composite, InstantiationContext context) {
        ArrayList<LogicalComponent<CompositeImplementation>> children = new ArrayList<LogicalComponent<CompositeImplementation>>();
        for (ComponentDefinition componentDefinition : composite.getComponents().values()) {
            Object childComponent = componentDefinition.getImplementation() instanceof CompositeImplementation ? this.instantiate((ComponentDefinition<CompositeImplementation>)componentDefinition, component, context) : this.atomicInstantiator.instantiate(componentDefinition, component, context);
            component.addComponent(childComponent);
            children.add((LogicalComponent<CompositeImplementation>)childComponent);
        }
        for (LogicalComponent logicalComponent : children) {
            this.wireInstantiator.instantiateReferenceWires(logicalComponent, context);
        }
    }

    private void instantiateCompositeServices(LogicalCompositeComponent component, Composite composite) {
        ComponentDefinition definition = component.getDefinition();
        String uriBase = component.getUri().toString() + "/";
        for (CompositeService service : composite.getCompositeServices().values()) {
            LogicalBinding logicalBinding;
            String name = service.getName();
            URI serviceUri = component.getUri().resolve('#' + name);
            LogicalService logicalService = new LogicalService(serviceUri, (ServiceDefinition)service, (LogicalComponent)component);
            logicalService.setPromotedUri(URI.create(uriBase + service.getPromote()));
            for (BindingDefinition binding : service.getBindings()) {
                logicalBinding = new LogicalBinding(binding, (Bindable)logicalService);
                logicalService.addBinding(logicalBinding);
            }
            for (BindingDefinition binding : service.getCallbackBindings()) {
                logicalBinding = new LogicalBinding(binding, (Bindable)logicalService);
                logicalService.addCallbackBinding(logicalBinding);
            }
            ComponentService componentService = (ComponentService)definition.getServices().get(name);
            if (componentService != null) {
                if (!componentService.getBindings().isEmpty()) {
                    ArrayList<LogicalBinding> bindings = new ArrayList<LogicalBinding>();
                    for (BindingDefinition binding : componentService.getBindings()) {
                        LogicalBinding logicalBinding2 = new LogicalBinding(binding, (Bindable)logicalService);
                        bindings.add(logicalBinding2);
                    }
                    logicalService.overrideBindings(bindings);
                }
                logicalService.addIntents(componentService.getIntents());
            }
            component.addService(logicalService);
        }
    }

    private void instantiateCompositeReferences(LogicalCompositeComponent component, Composite composite) {
        ComponentDefinition definition = component.getDefinition();
        String uriBase = component.getUri().toString() + "/";
        for (CompositeReference reference : composite.getCompositeReferences().values()) {
            LogicalBinding logicalBinding;
            String name = reference.getName();
            URI referenceUri = component.getUri().resolve('#' + name);
            LogicalReference logicalReference = new LogicalReference(referenceUri, (ReferenceDefinition)reference, (LogicalComponent)component);
            for (BindingDefinition binding : reference.getBindings()) {
                logicalBinding = new LogicalBinding(binding, (Bindable)logicalReference);
                logicalReference.addBinding(logicalBinding);
            }
            for (BindingDefinition binding : reference.getCallbackBindings()) {
                logicalBinding = new LogicalBinding(binding, (Bindable)logicalReference);
                logicalReference.addCallbackBinding(logicalBinding);
            }
            for (URI promotedUri : reference.getPromotedUris()) {
                URI resolvedUri = URI.create(uriBase + promotedUri.toString());
                logicalReference.addPromotedUri(resolvedUri);
            }
            ComponentReference componentReference = (ComponentReference)definition.getReferences().get(name);
            if (componentReference != null) {
                if (!componentReference.getBindings().isEmpty()) {
                    ArrayList<LogicalBinding> bindings = new ArrayList<LogicalBinding>();
                    for (BindingDefinition binding : componentReference.getBindings()) {
                        LogicalBinding logicalBinding2 = new LogicalBinding(binding, (Bindable)logicalReference);
                        bindings.add(logicalBinding2);
                    }
                    logicalReference.overrideBindings(bindings);
                }
                logicalReference.addIntents(componentReference.getIntents());
            }
            component.addReference(logicalReference);
        }
    }

    private void instantiateResources(LogicalCompositeComponent component, Composite composite) {
        for (ResourceDefinition definition : composite.getResources()) {
            LogicalResource resource = new LogicalResource(definition, component);
            component.addResource(resource);
        }
    }
}

