/*
 * Decompiled with CFR 0.152.
 */
package org.fabric3.fabric.instantiator.promotion;

import java.net.URI;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import javax.xml.namespace.QName;
import org.fabric3.fabric.instantiator.InstantiationContext;
import org.fabric3.fabric.instantiator.PromotionNormalizer;
import org.fabric3.fabric.instantiator.promotion.InvalidNumberOfTargets;
import org.fabric3.fabric.instantiator.promotion.MutuallyExclusiveIntents;
import org.fabric3.model.type.component.Autowire;
import org.fabric3.model.type.component.BindingDefinition;
import org.fabric3.model.type.component.Multiplicity;
import org.fabric3.model.type.component.ReferenceDefinition;
import org.fabric3.model.type.definitions.Intent;
import org.fabric3.spi.generator.policy.PolicyRegistry;
import org.fabric3.spi.model.instance.Bindable;
import org.fabric3.spi.model.instance.LogicalBinding;
import org.fabric3.spi.model.instance.LogicalComponent;
import org.fabric3.spi.model.instance.LogicalCompositeComponent;
import org.fabric3.spi.model.instance.LogicalReference;
import org.fabric3.spi.model.instance.LogicalService;
import org.fabric3.spi.model.instance.LogicalWire;
import org.fabric3.spi.util.UriHelper;
import org.oasisopen.sca.annotation.Constructor;
import org.oasisopen.sca.annotation.Reference;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PromotionNormalizerImpl
implements PromotionNormalizer {
    private PolicyRegistry registry;

    public PromotionNormalizerImpl() {
    }

    @Constructor
    public PromotionNormalizerImpl(@Reference PolicyRegistry registry) {
        this.registry = registry;
    }

    @Override
    public void normalize(LogicalComponent<?> component, InstantiationContext context) {
        this.normalizeServicePromotions(component, context);
        this.normalizeReferenceAndWirePromotions(component, context);
    }

    private void normalizeServicePromotions(LogicalComponent<?> component, InstantiationContext context) {
        for (LogicalService service : component.getServices()) {
            LinkedList<LogicalService> services = new LinkedList<LogicalService>();
            services.add(service);
            this.getPromotionHierarchy(service, services);
            if (services.isEmpty()) continue;
            this.processServicePromotions(services, context);
        }
    }

    private void normalizeReferenceAndWirePromotions(LogicalComponent<?> component, InstantiationContext context) {
        for (LogicalReference reference : component.getReferences()) {
            LinkedList<LogicalReference> references = new LinkedList<LogicalReference>();
            references.add(reference);
            this.getPromotionHierarchy(reference, references);
            if (references.isEmpty()) continue;
            this.processReferencePromotions(references, context);
            this.processWirePromotions(references, context);
        }
    }

    private void processServicePromotions(LinkedList<LogicalService> services, InstantiationContext context) {
        if (services.size() < 2) {
            return;
        }
        LogicalService leafService = services.getLast();
        LogicalComponent leafComponent = (LogicalComponent)leafService.getParent();
        ArrayList bindings = new ArrayList();
        HashSet intents = new HashSet();
        HashSet policySets = new HashSet();
        for (LogicalService service : services) {
            if (service.getBindings().isEmpty()) {
                service.overrideBindings(bindings);
            } else {
                bindings = new ArrayList();
                bindings.addAll(service.getBindings());
            }
            if (service.getIntents().isEmpty()) {
                service.addIntents(intents);
            } else {
                intents = new HashSet();
                intents.addAll(service.getIntents());
            }
            if (service.getPolicySets().isEmpty()) {
                service.addPolicySets(policySets);
            } else {
                policySets = new HashSet();
                policySets.addAll(service.getPolicySets());
            }
            this.validateIntents((Bindable)service, context);
            service.setLeafComponent(leafComponent);
            service.setLeafService(leafService);
        }
    }

    private void processReferencePromotions(LinkedList<LogicalReference> references, InstantiationContext context) {
        if (references.size() < 2) {
            return;
        }
        LogicalReference leafReference = references.getLast();
        ArrayList bindings = new ArrayList();
        HashSet intents = new HashSet();
        HashSet policySets = new HashSet();
        Autowire autowire = Autowire.INHERITED;
        for (LogicalReference reference : references) {
            ReferenceDefinition referenceDefinition = reference.getDefinition();
            if (referenceDefinition.getAutowire() == Autowire.INHERITED) {
                reference.setAutowire(autowire);
            } else {
                autowire = referenceDefinition.getAutowire();
            }
            if (reference.getBindings().isEmpty()) {
                ArrayList<LogicalBinding> newBindings = new ArrayList<LogicalBinding>();
                for (LogicalBinding binding : bindings) {
                    BindingDefinition definition = binding.getDefinition();
                    QName deployable = binding.getDeployable();
                    LogicalBinding newBinding = new LogicalBinding(definition, (Bindable)reference, deployable);
                    newBindings.add(newBinding);
                }
                reference.overrideBindings(newBindings);
            } else {
                bindings = new ArrayList();
                bindings.addAll(reference.getBindings());
            }
            if (reference.getIntents().isEmpty()) {
                reference.addIntents(intents);
            } else {
                intents = new HashSet();
                intents.addAll(reference.getIntents());
            }
            if (reference.getPolicySets().isEmpty()) {
                reference.addPolicySets(policySets);
            } else {
                policySets = new HashSet();
                policySets.addAll(reference.getPolicySets());
            }
            reference.setLeafReference(leafReference);
        }
        this.validateIntents((Bindable)leafReference, context);
    }

    private void validateIntents(Bindable bindable, InstantiationContext context) {
        if (this.registry == null) {
            return;
        }
        Set intents = bindable.getIntents();
        if (intents.isEmpty()) {
            return;
        }
        Set resolved = this.registry.getDefinitions(intents, Intent.class);
        for (Intent intent : resolved) {
            for (QName exclude : intent.getExcludes()) {
                if (!intents.contains(exclude)) continue;
                String prefix = bindable instanceof LogicalReference ? "Reference " : "Service ";
                MutuallyExclusiveIntents error = new MutuallyExclusiveIntents(prefix + bindable.getUri() + " is configured with mutually exclusive intents: " + intent.getName() + "," + exclude, bindable);
                context.addError(error);
            }
        }
    }

    private void processWirePromotions(LinkedList<LogicalReference> references, InstantiationContext context) {
        if (references.size() < 2) {
            return;
        }
        ArrayList<LogicalService> newTargets = new ArrayList<LogicalService>();
        for (LogicalReference reference : references) {
            LogicalCompositeComponent composite = (LogicalCompositeComponent)((LogicalComponent)reference.getParent()).getParent();
            for (LogicalWire wire : reference.getWires()) {
                LogicalService target = wire.getTarget();
                newTargets.add(target);
            }
            if (!newTargets.isEmpty()) {
                ArrayList<LogicalWire> newWires = new ArrayList<LogicalWire>();
                for (LogicalService target : newTargets) {
                    QName deployable = composite.getDeployable();
                    LogicalWire newWire = new LogicalWire((LogicalComponent)reference.getParent(), reference, target, deployable);
                    newWires.add(newWire);
                }
                composite.overrideWires(reference, newWires);
            }
            if (this.validateMultiplicity(reference, newTargets, context)) continue;
            return;
        }
    }

    private boolean validateMultiplicity(LogicalReference reference, List<LogicalService> targets, InstantiationContext context) {
        if (((LogicalComponent)reference.getParent()).getAutowire() == Autowire.ON || !reference.getBindings().isEmpty() || reference.getAutowire() == Autowire.ON || reference.getComponentReference() != null) {
            return true;
        }
        Multiplicity multiplicity = reference.getDefinition().getMultiplicity();
        switch (multiplicity) {
            case ONE_N: {
                if (targets.size() < 1) {
                    URI referenceName = reference.getUri();
                    InvalidNumberOfTargets error = new InvalidNumberOfTargets("At least one target must be configured for reference: " + referenceName, reference);
                    context.addError(error);
                    return false;
                }
                return true;
            }
            case ONE_ONE: {
                if (targets.size() < 1) {
                    URI referenceName = reference.getUri();
                    InvalidNumberOfTargets error = new InvalidNumberOfTargets("At least one target must be configured for reference (no targets configured): " + referenceName, reference);
                    context.addError(error);
                    return false;
                }
                if (targets.size() > 1) {
                    URI referenceName = reference.getUri();
                    InvalidNumberOfTargets error = new InvalidNumberOfTargets("Only one target must be configured for reference (multiple targets configured via promotions): " + referenceName, reference);
                    context.addError(error);
                    return false;
                }
                return true;
            }
            case ZERO_N: {
                return true;
            }
            case ZERO_ONE: {
                if (targets.size() > 1) {
                    URI referenceName = reference.getUri();
                    InvalidNumberOfTargets error = new InvalidNumberOfTargets("At most one target must be configured for reference (multiple targets configured via promotions): " + referenceName, reference);
                    context.addError(error);
                    return false;
                }
                return true;
            }
        }
        return true;
    }

    private void getPromotionHierarchy(LogicalService service, LinkedList<LogicalService> services) {
        LogicalComponent parent = (LogicalComponent)((LogicalComponent)service.getParent()).getParent();
        URI serviceUri = service.getUri();
        for (LogicalService promotion : parent.getServices()) {
            URI targetUri = promotion.getPromotedUri();
            if (targetUri.getFragment() == null) {
                if (!targetUri.equals(UriHelper.getDefragmentedName((URI)serviceUri))) continue;
                services.addFirst(promotion);
                if (parent.getParent() == null) continue;
                this.getPromotionHierarchy(promotion, services);
                continue;
            }
            if (!targetUri.equals(serviceUri)) continue;
            services.addFirst(promotion);
            if (parent.getParent() == null) continue;
            this.getPromotionHierarchy(promotion, services);
        }
    }

    private void getPromotionHierarchy(LogicalReference reference, LinkedList<LogicalReference> references) {
        URI referenceUri = reference.getUri();
        LogicalComponent parent = (LogicalComponent)((LogicalComponent)reference.getParent()).getParent();
        for (LogicalReference promotion : parent.getReferences()) {
            List promotedUris = promotion.getPromotedUris();
            for (URI promotedUri : promotedUris) {
                if (promotedUri.getFragment() == null) {
                    if (!promotedUri.equals(UriHelper.getDefragmentedName((URI)referenceUri))) continue;
                    references.addFirst(promotion);
                    if (parent.getParent() == null) continue;
                    this.getPromotionHierarchy(promotion, references);
                    continue;
                }
                if (!promotedUri.equals(referenceUri)) continue;
                references.addFirst(promotion);
                if (parent.getParent() == null) continue;
                this.getPromotionHierarchy(promotion, references);
            }
        }
    }
}

