/*
 * Decompiled with CFR 0.152.
 */
package org.fabric3.fabric.instantiator.wire;

import java.util.ArrayList;
import java.util.List;
import javax.xml.namespace.QName;
import org.fabric3.fabric.instantiator.AutowireInstantiator;
import org.fabric3.fabric.instantiator.InstantiationContext;
import org.fabric3.fabric.instantiator.ReferenceNotFound;
import org.fabric3.model.type.component.Autowire;
import org.fabric3.model.type.component.BindingDefinition;
import org.fabric3.model.type.component.ComponentReference;
import org.fabric3.model.type.component.Multiplicity;
import org.fabric3.model.type.component.ReferenceDefinition;
import org.fabric3.model.type.contract.ServiceContract;
import org.fabric3.spi.contract.ContractMatcher;
import org.fabric3.spi.contract.MatchResult;
import org.fabric3.spi.model.instance.LogicalBinding;
import org.fabric3.spi.model.instance.LogicalComponent;
import org.fabric3.spi.model.instance.LogicalCompositeComponent;
import org.fabric3.spi.model.instance.LogicalReference;
import org.fabric3.spi.model.instance.LogicalService;
import org.fabric3.spi.model.instance.LogicalState;
import org.fabric3.spi.model.instance.LogicalWire;
import org.fabric3.spi.model.type.binding.SCABinding;
import org.oasisopen.sca.annotation.Reference;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AutowireInstantiatorImpl
implements AutowireInstantiator {
    private ContractMatcher matcher;

    public AutowireInstantiatorImpl(@Reference ContractMatcher matcher) {
        this.matcher = matcher;
    }

    @Override
    public void instantiate(LogicalComponent<?> component, InstantiationContext context) {
        this.resolveReferences(component, context);
        if (component instanceof LogicalCompositeComponent) {
            LogicalCompositeComponent compositeComponent = (LogicalCompositeComponent)component;
            for (LogicalComponent child : compositeComponent.getComponents()) {
                this.instantiate(child, context);
            }
        }
    }

    private void resolveReferences(LogicalComponent<?> component, InstantiationContext context) {
        LogicalCompositeComponent parent = (LogicalCompositeComponent)component.getParent();
        for (LogicalReference reference : component.getReferences()) {
            boolean refMultiplicity;
            boolean scaTarget = this.isScaTarget(reference);
            if (scaTarget || reference.isConcreteBound()) continue;
            Multiplicity multiplicityValue = reference.getDefinition().getMultiplicity();
            boolean bl = refMultiplicity = multiplicityValue.equals((Object)Multiplicity.ZERO_N) || multiplicityValue.equals((Object)Multiplicity.ONE_N);
            if (!refMultiplicity && reference.isResolved()) continue;
            reference.setResolved(false);
            this.resolve(reference, parent, context);
        }
    }

    private boolean isScaTarget(LogicalReference reference) {
        boolean scaTarget = false;
        for (LogicalBinding binding : reference.getBindings()) {
            BindingDefinition definition = binding.getDefinition();
            if (!(definition instanceof SCABinding) || ((SCABinding)definition).getTarget() == null) continue;
            scaTarget = true;
            break;
        }
        return scaTarget;
    }

    private void resolve(LogicalReference logicalReference, LogicalCompositeComponent compositeComponent, InstantiationContext context) {
        boolean targeted;
        ComponentReference componentReference = logicalReference.getComponentReference();
        LogicalComponent component = (LogicalComponent)logicalReference.getParent();
        if (componentReference == null) {
            if (logicalReference.isResolved()) {
                return;
            }
            ServiceContract requiredContract = logicalReference.getServiceContract();
            Autowire autowire = component.getAutowire();
            if (autowire == Autowire.ON) {
                this.resolveByType(compositeComponent, logicalReference, requiredContract);
            }
        } else {
            List targets = componentReference.getTargets();
            if (!targets.isEmpty()) {
                return;
            }
            if (componentReference.getAutowire() == Autowire.ON || componentReference.getAutowire() == Autowire.INHERITED && component.getAutowire() == Autowire.ON) {
                ReferenceDefinition referenceDefinition = logicalReference.getDefinition();
                ServiceContract requiredContract = referenceDefinition.getServiceContract();
                boolean resolved = this.resolveByType((LogicalCompositeComponent)component.getParent(), logicalReference, requiredContract);
                if (!resolved) {
                    this.resolveByType(compositeComponent, logicalReference, requiredContract);
                }
            }
        }
        boolean bl = targeted = !logicalReference.getLeafReference().getWires().isEmpty();
        if (!targeted && logicalReference.getDefinition().isRequired() && !logicalReference.isConcreteBound()) {
            String referenceUri = logicalReference.getUri().toString();
            ReferenceNotFound error = new ReferenceNotFound("Unable to resolve reference " + referenceUri, logicalReference);
            context.addError(error);
        } else if (targeted) {
            logicalReference.setResolved(true);
        }
    }

    private boolean resolveByType(LogicalCompositeComponent composite, LogicalReference logicalReference, ServiceContract contract) {
        ArrayList<LogicalService> candidates = new ArrayList<LogicalService>();
        Multiplicity refMultiplicity = logicalReference.getDefinition().getMultiplicity();
        boolean multiplicity = Multiplicity.ZERO_N.equals((Object)refMultiplicity) || Multiplicity.ONE_N.equals((Object)refMultiplicity);
        for (LogicalComponent child : composite.getComponents()) {
            if (logicalReference.getParent() == child) continue;
            if (this.validKey(logicalReference, child)) {
                for (LogicalService service : child.getServices()) {
                    ServiceContract targetContract = service.getServiceContract();
                    if (targetContract == null) {
                        throw new AssertionError((Object)("No service contract specified on service: " + service.getUri()));
                    }
                    MatchResult result = this.matcher.isAssignableFrom(contract, targetContract, false);
                    if (!result.isAssignable()) continue;
                    boolean intentsMatch = true;
                    for (QName intent : logicalReference.getIntents()) {
                        if (service.getIntents().contains(intent)) continue;
                        intentsMatch = false;
                        break;
                    }
                    if (!intentsMatch) continue;
                    candidates.add(service);
                    break;
                }
            }
            if (candidates.isEmpty() || multiplicity) continue;
            break;
        }
        if (candidates.isEmpty()) {
            return false;
        }
        LogicalReference leafReference = logicalReference.getLeafReference();
        LogicalComponent parent = (LogicalComponent)leafReference.getParent();
        LogicalCompositeComponent parentComposite = (LogicalCompositeComponent)parent.getParent();
        List existingWires = parentComposite.getWires(leafReference);
        for (LogicalService target : candidates) {
            QName deployable = ((LogicalComponent)target.getParent()).getDeployable();
            boolean skip = false;
            for (LogicalWire existingWire : existingWires) {
                if (!target.equals(existingWire.getTarget())) continue;
                skip = true;
                break;
            }
            if (skip) continue;
            LogicalWire wire = new LogicalWire((LogicalComponent)parentComposite, leafReference, target, deployable, true);
            parentComposite.addWire(leafReference, wire);
            for (LogicalWire existingWire : existingWires) {
                if (LogicalState.PROVISIONED != existingWire.getTarget().getLeafComponent().getState()) continue;
                existingWire.setState(LogicalState.NEW);
            }
        }
        return true;
    }

    private boolean validKey(LogicalReference logicalReference, LogicalComponent<?> target) {
        return !logicalReference.getDefinition().isKeyed() || target.getDefinition().getKey() != null;
    }
}

