/*
 * Decompiled with CFR 0.152.
 */
package org.fabric3.fabric.runtime;

import java.io.File;
import java.net.URI;
import java.util.List;
import org.fabric3.fabric.runtime.DefaultCoordinator;
import org.fabric3.fabric.runtime.DefaultRuntime;
import org.fabric3.fabric.runtime.bootstrap.RepositoryScanner;
import org.fabric3.fabric.runtime.bootstrap.SystemConfigLoader;
import org.fabric3.host.RuntimeMode;
import org.fabric3.host.monitor.MonitorConfigurationException;
import org.fabric3.host.monitor.MonitorEventDispatcher;
import org.fabric3.host.runtime.BootConfiguration;
import org.fabric3.host.runtime.BootstrapService;
import org.fabric3.host.runtime.Fabric3Runtime;
import org.fabric3.host.runtime.HostInfo;
import org.fabric3.host.runtime.ParseException;
import org.fabric3.host.runtime.RuntimeConfiguration;
import org.fabric3.host.runtime.RuntimeCoordinator;
import org.fabric3.host.runtime.ScanException;
import org.fabric3.host.runtime.ScanResult;
import org.fabric3.host.stream.Source;
import org.fabric3.monitor.runtime.LogbackDispatcher;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultBootstrapService
implements BootstrapService {
    private RepositoryScanner scanner = new RepositoryScanner();
    private SystemConfigLoader systemConfigLoader = new SystemConfigLoader();

    public Document loadSystemConfig(File configDirectory) throws ParseException {
        return this.systemConfigLoader.loadSystemConfig(configDirectory);
    }

    public Document loadSystemConfig(Source source) throws ParseException {
        return this.systemConfigLoader.loadSystemConfig(source);
    }

    public Document createDefaultSystemConfig() {
        return this.systemConfigLoader.createDefaultSystemConfig();
    }

    public URI parseDomainName(Document systemConfig) throws ParseException {
        return this.systemConfigLoader.parseDomainName(systemConfig);
    }

    public String parseZoneName(Document systemConfig) throws ParseException {
        return this.systemConfigLoader.parseZoneName(systemConfig);
    }

    public RuntimeMode parseRuntimeMode(Document systemConfig) throws ParseException {
        return this.systemConfigLoader.parseRuntimeMode(systemConfig);
    }

    public String parseEnvironment(Document systemConfig) {
        return this.systemConfigLoader.parseEnvironment(systemConfig);
    }

    public List<File> parseDeployDirectories(Document systemConfig) throws ParseException {
        return this.systemConfigLoader.parseDeployDirectories(systemConfig);
    }

    public String getRuntimeName(URI domainName, String zoneName, String runtimeId, RuntimeMode mode) {
        String runtimeName = RuntimeMode.CONTROLLER == mode ? domainName.getAuthority() + ":controller:" + runtimeId : (RuntimeMode.PARTICIPANT == mode ? domainName.getAuthority() + ":participant:" + zoneName + ":" + runtimeId : "vm");
        return runtimeName;
    }

    public MonitorEventDispatcher createMonitorDispatcher(String elementName, Document systemConfig, HostInfo hostInfo) throws MonitorConfigurationException {
        boolean additive = !"application.monitor".equals(elementName);
        File dataDir = hostInfo.getDataDir();
        LogbackDispatcher dispatcher = new LogbackDispatcher(elementName, additive, dataDir);
        Element element = this.systemConfigLoader.getMonitorConfiguration(elementName, systemConfig);
        if (element != null) {
            dispatcher.configure(element);
        }
        return dispatcher;
    }

    public ScanResult scanRepository(HostInfo info) throws ScanException {
        return this.scanner.scan(info);
    }

    public Fabric3Runtime createDefaultRuntime(RuntimeConfiguration configuration) {
        return new DefaultRuntime(configuration);
    }

    public RuntimeCoordinator createCoordinator(BootConfiguration configuration) {
        return new DefaultCoordinator(configuration);
    }
}

