/*
 * Decompiled with CFR 0.152.
 */
package org.fabric3.fabric.runtime;

import java.net.URI;
import java.net.URL;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import javax.management.MBeanServer;
import org.fabric3.contribution.manifest.ContributionExport;
import org.fabric3.fabric.instantiator.AtomicComponentInstantiator;
import org.fabric3.fabric.instantiator.component.AtomicComponentInstantiatorImpl;
import org.fabric3.fabric.runtime.Bootstrapper;
import org.fabric3.fabric.runtime.RuntimeServices;
import org.fabric3.fabric.runtime.bootstrap.BootstrapAssemblyFactory;
import org.fabric3.fabric.runtime.bootstrap.BootstrapCompositeFactory;
import org.fabric3.fabric.runtime.bootstrap.BootstrapIntrospectionFactory;
import org.fabric3.fabric.runtime.bootstrap.Java6HostExports;
import org.fabric3.fabric.synthesizer.SingletonComponentSynthesizer;
import org.fabric3.host.Names;
import org.fabric3.host.Version;
import org.fabric3.host.contribution.ContributionException;
import org.fabric3.host.domain.DeploymentException;
import org.fabric3.host.domain.Domain;
import org.fabric3.host.monitor.MonitorProxyService;
import org.fabric3.host.repository.Repository;
import org.fabric3.host.runtime.BootConfiguration;
import org.fabric3.host.runtime.BootExports;
import org.fabric3.host.runtime.ComponentRegistration;
import org.fabric3.host.runtime.Fabric3Runtime;
import org.fabric3.host.runtime.HostInfo;
import org.fabric3.host.runtime.InitializationException;
import org.fabric3.introspection.java.DefaultIntrospectionHelper;
import org.fabric3.introspection.java.contract.JavaContractProcessorImpl;
import org.fabric3.model.type.component.ChannelDefinition;
import org.fabric3.model.type.component.Composite;
import org.fabric3.spi.channel.ChannelManager;
import org.fabric3.spi.classloader.ClassLoaderRegistry;
import org.fabric3.spi.cm.ComponentManager;
import org.fabric3.spi.component.ScopeContainer;
import org.fabric3.spi.component.ScopeRegistry;
import org.fabric3.spi.contribution.Capability;
import org.fabric3.spi.contribution.Contribution;
import org.fabric3.spi.contribution.ContributionManifest;
import org.fabric3.spi.contribution.ContributionState;
import org.fabric3.spi.contribution.Export;
import org.fabric3.spi.contribution.MetaDataStore;
import org.fabric3.spi.contribution.manifest.JavaExport;
import org.fabric3.spi.contribution.manifest.PackageInfo;
import org.fabric3.spi.introspection.java.ImplementationProcessor;
import org.fabric3.spi.introspection.java.IntrospectionHelper;
import org.fabric3.spi.introspection.java.contract.JavaContractProcessor;
import org.fabric3.spi.lcm.LogicalComponentManager;
import org.fabric3.spi.management.ManagementService;
import org.fabric3.spi.model.instance.LogicalChannel;
import org.fabric3.spi.model.instance.LogicalComponent;
import org.fabric3.spi.model.instance.LogicalCompositeComponent;
import org.fabric3.spi.model.instance.LogicalProperty;
import org.fabric3.spi.model.instance.LogicalState;
import org.fabric3.spi.synthesize.ComponentRegistrationException;
import org.fabric3.spi.synthesize.ComponentSynthesizer;
import org.w3c.dom.Document;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultBootstrapper
implements Bootstrapper {
    private static final URI RUNTIME_SERVICES = URI.create("fabric3://RuntimeServices");
    private JavaContractProcessorImpl contractProcessor;
    private AtomicComponentInstantiatorImpl instantiator;
    private ImplementationProcessor implementationProcessor;
    private ComponentSynthesizer synthesizer;
    private MonitorProxyService monitorService;
    private ClassLoaderRegistry classLoaderRegistry;
    private MetaDataStore metaDataStore;
    private ScopeRegistry scopeRegistry;
    private LogicalCompositeComponent domain;
    private LogicalComponentManager lcm;
    private ComponentManager componentManager;
    private ChannelManager channelManager;
    private ScopeContainer scopeContainer;
    private Repository repository;
    private MBeanServer mbeanServer;
    private ManagementService managementService;
    private HostInfo hostInfo;
    private Domain runtimeDomain;
    private Fabric3Runtime runtime;
    private URL systemCompositeUrl;
    private Document systemConfig;
    private ClassLoader bootClassLoader;
    private Map<String, String> exportedPackages;
    private List<String> hostCapabilities;
    private ClassLoader hostClassLoader;
    private Contribution bootContribution;
    private List<ComponentRegistration> registrations;

    public DefaultBootstrapper(BootConfiguration configuration) {
        this.runtime = configuration.getRuntime();
        this.systemCompositeUrl = configuration.getSystemCompositeUrl();
        this.systemConfig = configuration.getSystemConfig();
        this.hostClassLoader = configuration.getHostClassLoader();
        this.bootClassLoader = configuration.getBootClassLoader();
        this.exportedPackages = configuration.getExportedPackages();
        this.hostCapabilities = configuration.getHostCapabilities();
        this.registrations = configuration.getRegistrations();
        DefaultIntrospectionHelper helper = new DefaultIntrospectionHelper();
        this.contractProcessor = new JavaContractProcessorImpl((IntrospectionHelper)helper);
        this.instantiator = new AtomicComponentInstantiatorImpl();
        this.implementationProcessor = BootstrapIntrospectionFactory.createSystemImplementationProcessor();
    }

    @Override
    public void bootRuntimeDomain() throws InitializationException {
        RuntimeServices runtimeServices = (RuntimeServices)this.runtime.getComponent(RuntimeServices.class, RUNTIME_SERVICES);
        this.hostInfo = runtimeServices.getHostInfo();
        this.monitorService = runtimeServices.getMonitorProxyService();
        this.lcm = runtimeServices.getLogicalComponentManager();
        this.componentManager = runtimeServices.getComponentManager();
        this.channelManager = runtimeServices.getChannelManager();
        this.domain = this.lcm.getRootComponent();
        this.classLoaderRegistry = runtimeServices.getClassLoaderRegistry();
        this.metaDataStore = runtimeServices.getMetaDataStore();
        this.scopeRegistry = runtimeServices.getScopeRegistry();
        this.scopeContainer = runtimeServices.getScopeContainer();
        this.repository = runtimeServices.getRepository();
        this.mbeanServer = runtimeServices.getMBeanServer();
        this.managementService = runtimeServices.getManagementService();
        this.hostInfo = runtimeServices.getHostInfo();
        this.synthesizer = new SingletonComponentSynthesizer(this.implementationProcessor, (AtomicComponentInstantiator)this.instantiator, this.lcm, this.componentManager, (JavaContractProcessor)this.contractProcessor, this.scopeContainer);
        this.registerRuntimeComponents(this.registrations);
        this.runtimeDomain = BootstrapAssemblyFactory.createDomain(this.monitorService, this.classLoaderRegistry, this.scopeRegistry, this.componentManager, this.lcm, this.channelManager, this.metaDataStore, this.managementService, this.hostInfo);
        this.registerComponent("RuntimeDomain", Domain.class, this.runtimeDomain, true);
        this.registerRuntimeDomainChannel();
        this.synthesizeContributions();
    }

    @Override
    public void bootSystem() throws InitializationException {
        try {
            Composite composite = BootstrapCompositeFactory.createSystemComposite(this.systemCompositeUrl, this.bootContribution, this.bootClassLoader, this.implementationProcessor);
            LogicalProperty logicalProperty = new LogicalProperty("systemConfig", this.systemConfig, false, (LogicalComponent)this.domain);
            this.domain.setProperties(logicalProperty);
            this.runtimeDomain.include(composite, false);
        }
        catch (DeploymentException e) {
            throw new InitializationException((Throwable)e);
        }
    }

    private <S, I extends S> void registerRuntimeComponents(List<ComponentRegistration> registrations) throws InitializationException {
        this.registerComponent("MonitorProxyService", MonitorProxyService.class, this.monitorService, true);
        Class<HostInfo> type = this.getHostInfoType(this.hostInfo);
        this.registerComponent("HostInfo", type, this.hostInfo, true);
        if (this.mbeanServer != null) {
            this.registerComponent("MBeanServer", MBeanServer.class, this.mbeanServer, false);
        }
        this.registerComponent("ManagementService", ManagementService.class, this.managementService, true);
        this.registerComponent("ComponentManager", ComponentManager.class, this.componentManager, true);
        this.registerComponent("ChannelManager", ChannelManager.class, this.channelManager, true);
        this.registerComponent("RuntimeLogicalComponentManager", LogicalComponentManager.class, this.lcm, true);
        this.registerComponent("CompositeScopeContainer", ScopeContainer.class, this.scopeContainer, true);
        this.registerComponent("ClassLoaderRegistry", ClassLoaderRegistry.class, this.classLoaderRegistry, true);
        this.registerComponent("ScopeRegistry", ScopeRegistry.class, this.scopeRegistry, true);
        this.registerComponent("MetaDataStore", MetaDataStore.class, this.metaDataStore, true);
        this.registerComponent("Repository", Repository.class, this.repository, true);
        for (ComponentRegistration registration : registrations) {
            String name = registration.getName();
            Class service = registration.getService();
            Object instance = registration.getInstance();
            boolean introspect = registration.isIntrospect();
            this.registerComponent(name, service, instance, introspect);
        }
    }

    private Class<HostInfo> getHostInfoType(HostInfo info) {
        Class<?>[] interfaces = info.getClass().getInterfaces();
        if (interfaces.length == 1) {
            return HostInfo.class;
        }
        for (Class<HostInfo> clazz : interfaces) {
            if (HostInfo.class.equals(clazz) || !HostInfo.class.isAssignableFrom(clazz)) continue;
            return clazz;
        }
        return HostInfo.class;
    }

    private <S, I extends S> void registerComponent(String name, Class<S> type, I instance, boolean introspect) throws InitializationException {
        try {
            this.synthesizer.registerComponent(name, type, instance, introspect);
        }
        catch (ComponentRegistrationException e) {
            throw new InitializationException((Throwable)e);
        }
    }

    private void registerRuntimeDomainChannel() {
        ChannelDefinition definition = new ChannelDefinition("RuntimeMonitorChannel", Names.BOOT_CONTRIBUTION);
        LogicalCompositeComponent domain = this.lcm.getRootComponent();
        LogicalChannel logicalChannel = new LogicalChannel(Names.RUNTIME_MONITOR_CHANNEL_URI, definition, domain);
        logicalChannel.setState(LogicalState.PROVISIONED);
        domain.addChannel(logicalChannel);
    }

    private void synthesizeContributions() throws InitializationException {
        try {
            this.synthesizeContribution(Names.HOST_CONTRIBUTION, Java6HostExports.getExports(), this.hostCapabilities, this.hostClassLoader, true);
            this.exportedPackages.putAll(BootExports.getExports());
            this.bootContribution = this.synthesizeContribution(Names.BOOT_CONTRIBUTION, this.exportedPackages, Collections.<String>emptyList(), this.bootClassLoader, true);
        }
        catch (ContributionException e) {
            throw new InitializationException((Throwable)e);
        }
    }

    private Contribution synthesizeContribution(URI contributionUri, Map<String, String> exportedPackages, List<String> hostCapabilities, ClassLoader loader, boolean extension) throws ContributionException {
        Contribution contribution = new Contribution(contributionUri);
        contribution.setState(ContributionState.INSTALLED);
        ContributionManifest manifest = contribution.getManifest();
        manifest.setExtension(extension);
        manifest.addExport((Export)new ContributionExport(contributionUri));
        for (Map.Entry<String, String> entry : exportedPackages.entrySet()) {
            Version version = new Version(entry.getValue());
            PackageInfo info = new PackageInfo(entry.getKey(), version);
            JavaExport export = new JavaExport(info);
            manifest.addExport((Export)export);
        }
        for (String capability : hostCapabilities) {
            manifest.addProvidedCapability(new Capability(capability));
        }
        this.metaDataStore.store(contribution);
        this.classLoaderRegistry.register(contributionUri, loader);
        return contribution;
    }
}

