/*
 * Decompiled with CFR 0.152.
 */
package org.fabric3.fabric.runtime;

import java.net.URI;
import java.util.Collections;
import java.util.List;
import org.fabric3.fabric.runtime.DefaultBootstrapper;
import org.fabric3.fabric.runtime.ExtensionInitializationException;
import org.fabric3.host.Names;
import org.fabric3.host.contribution.ContributionException;
import org.fabric3.host.contribution.ContributionNotFoundException;
import org.fabric3.host.contribution.ContributionOrder;
import org.fabric3.host.contribution.ContributionService;
import org.fabric3.host.contribution.ContributionSource;
import org.fabric3.host.contribution.InstallException;
import org.fabric3.host.contribution.StoreException;
import org.fabric3.host.domain.DeploymentException;
import org.fabric3.host.domain.Domain;
import org.fabric3.host.runtime.BootConfiguration;
import org.fabric3.host.runtime.Fabric3Runtime;
import org.fabric3.host.runtime.InitializationException;
import org.fabric3.host.runtime.RuntimeCoordinator;
import org.fabric3.host.runtime.RuntimeState;
import org.fabric3.host.runtime.ShutdownException;
import org.fabric3.spi.event.DomainRecover;
import org.fabric3.spi.event.DomainRecovered;
import org.fabric3.spi.event.EventService;
import org.fabric3.spi.event.ExtensionsInitialized;
import org.fabric3.spi.event.Fabric3Event;
import org.fabric3.spi.event.JoinDomain;
import org.fabric3.spi.event.RuntimeRecover;
import org.fabric3.spi.event.RuntimeStart;
import org.fabric3.spi.event.RuntimeStop;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultCoordinator
implements RuntimeCoordinator {
    private RuntimeState state = RuntimeState.UNINITIALIZED;
    private BootConfiguration configuration;
    private Fabric3Runtime runtime;

    public DefaultCoordinator(BootConfiguration configuration) {
        this.configuration = configuration;
        this.runtime = configuration.getRuntime();
    }

    public RuntimeState getState() {
        return this.state;
    }

    public void start() throws InitializationException {
        this.prepare();
        this.joinAndStart();
    }

    public void prepare() throws InitializationException {
        this.runtime.boot();
        DefaultBootstrapper bootstrapper = new DefaultBootstrapper(this.configuration);
        bootstrapper.bootRuntimeDomain();
        bootstrapper.bootSystem();
        this.loadExtensions();
        EventService eventService = (EventService)this.runtime.getComponent(EventService.class);
        eventService.publish((Fabric3Event)new ExtensionsInitialized());
        this.recover(eventService);
    }

    public void joinAndStart() {
        EventService eventService = (EventService)this.runtime.getComponent(EventService.class);
        eventService.publish((Fabric3Event)new JoinDomain());
        eventService.publish((Fabric3Event)new DomainRecover());
        eventService.publish((Fabric3Event)new DomainRecovered());
        eventService.publish((Fabric3Event)new RuntimeStart());
        this.state = RuntimeState.STARTED;
    }

    public void shutdown() throws ShutdownException {
        if (this.state == RuntimeState.STARTED) {
            EventService eventService = (EventService)this.runtime.getComponent(EventService.class);
            eventService.publish((Fabric3Event)new RuntimeStop());
            this.runtime.destroy();
        }
        this.state = RuntimeState.SHUTDOWN;
    }

    private void loadExtensions() throws InitializationException {
        List contributions = this.configuration.getExtensionContributions();
        ContributionService contributionService = (ContributionService)this.runtime.getComponent(ContributionService.class);
        Domain domain = (Domain)this.runtime.getComponent(Domain.class, Names.RUNTIME_DOMAIN_SERVICE_URI);
        try {
            ContributionOrder order = contributionService.processManifests(contributions);
            for (URI uri : order.getBaseContributions()) {
                contributionService.processContents(uri);
            }
            domain.include(order.getBaseContributions());
            for (URI uri : order.getIsolatedContributions()) {
                contributionService.processContents(uri);
                domain.include(Collections.singletonList(uri));
            }
        }
        catch (InstallException e) {
            throw new InitializationException((Throwable)e);
        }
        catch (StoreException e) {
            throw new InitializationException((Throwable)e);
        }
        catch (ContributionNotFoundException e) {
            throw new InitializationException((Throwable)e);
        }
        catch (DeploymentException e) {
            this.state = RuntimeState.ERROR;
            throw new ExtensionInitializationException("Error deploying extensions", e);
        }
    }

    private void recover(EventService eventService) throws InitializationException {
        Domain domain = (Domain)this.runtime.getComponent(Domain.class, Names.APPLICATION_DOMAIN_URI);
        if (domain == null) {
            this.state = RuntimeState.ERROR;
            String name = Names.APPLICATION_DOMAIN_URI.toString();
            throw new InitializationException("Domain not found: " + name);
        }
        List contributions = this.configuration.getUserContributions();
        if (!contributions.isEmpty()) {
            this.installContributions(contributions);
        }
        eventService.publish((Fabric3Event)new RuntimeRecover());
    }

    private List<URI> installContributions(List<ContributionSource> sources) throws InitializationException {
        try {
            ContributionService contributionService = (ContributionService)this.runtime.getComponent(ContributionService.class, Names.CONTRIBUTION_SERVICE_URI);
            List stored = contributionService.store(sources);
            return contributionService.install(stored);
        }
        catch (ContributionException e) {
            this.state = RuntimeState.ERROR;
            throw new ExtensionInitializationException("Error contributing extensions", e);
        }
    }
}

