/*
 * Decompiled with CFR 0.152.
 */
package org.fabric3.fabric.runtime.bootstrap;

import org.fabric3.implementation.system.introspection.SystemImplementationLoader;
import org.fabric3.implementation.system.model.SystemImplementation;
import org.fabric3.introspection.xml.DefaultLoaderHelper;
import org.fabric3.introspection.xml.LoaderRegistryImpl;
import org.fabric3.introspection.xml.common.ComponentConsumerLoader;
import org.fabric3.introspection.xml.common.ComponentProducerLoader;
import org.fabric3.introspection.xml.common.ComponentReferenceLoader;
import org.fabric3.introspection.xml.common.ComponentServiceLoader;
import org.fabric3.introspection.xml.common.PropertyLoader;
import org.fabric3.introspection.xml.composite.ComponentLoader;
import org.fabric3.introspection.xml.composite.CompositeLoader;
import org.fabric3.introspection.xml.composite.IncludeLoader;
import org.fabric3.introspection.xml.composite.PropertyValueLoader;
import org.fabric3.introspection.xml.composite.WireLoader;
import org.fabric3.spi.introspection.java.ImplementationProcessor;
import org.fabric3.spi.introspection.xml.CompositeConstants;
import org.fabric3.spi.introspection.xml.Loader;
import org.fabric3.spi.introspection.xml.LoaderHelper;
import org.fabric3.spi.introspection.xml.LoaderRegistry;
import org.fabric3.spi.introspection.xml.TypeLoader;
import org.fabric3.spi.xml.XMLFactory;

public class BootstrapLoaderFactory {
    private BootstrapLoaderFactory() {
    }

    public static Loader createLoader(ImplementationProcessor processor, XMLFactory xmlFactory) {
        DefaultLoaderHelper loaderHelper = new DefaultLoaderHelper();
        LoaderRegistryImpl registry = new LoaderRegistryImpl(xmlFactory);
        SystemImplementationLoader systemLoader = new SystemImplementationLoader(processor);
        registry.registerLoader(SystemImplementation.IMPLEMENTATION_SYSTEM, (TypeLoader)systemLoader);
        WireLoader wireLoader = new WireLoader((LoaderHelper)loaderHelper);
        registry.registerLoader(CompositeConstants.WIRE, (TypeLoader)wireLoader);
        BootstrapLoaderFactory.compositeLoader((LoaderRegistry)registry, (LoaderHelper)loaderHelper);
        return registry;
    }

    private static CompositeLoader compositeLoader(LoaderRegistry registry, LoaderHelper loaderHelper) {
        PropertyValueLoader propertyValueLoader = new PropertyValueLoader(registry, loaderHelper);
        propertyValueLoader.init();
        ComponentReferenceLoader componentReferenceLoader = new ComponentReferenceLoader(registry, loaderHelper);
        componentReferenceLoader.init();
        ComponentServiceLoader componentServiceLoader = new ComponentServiceLoader(registry, loaderHelper);
        componentServiceLoader.init();
        ComponentConsumerLoader componentConsumerLoader = new ComponentConsumerLoader(registry);
        componentConsumerLoader.init();
        ComponentProducerLoader componentProducerLoader = new ComponentProducerLoader(registry);
        componentProducerLoader.init();
        ComponentLoader componentLoader = new ComponentLoader(registry, loaderHelper);
        componentLoader.init();
        IncludeLoader includeLoader = new IncludeLoader(registry);
        includeLoader.init();
        PropertyLoader propertyLoader = new PropertyLoader(loaderHelper);
        CompositeLoader compositeLoader = new CompositeLoader(registry, (TypeLoader)propertyLoader, loaderHelper);
        compositeLoader.init();
        return compositeLoader;
    }
}

