/*
 * Decompiled with CFR 0.152.
 */
package org.fabric3.fabric.runtime.bootstrap;

import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.fabric3.fabric.xml.DocumentLoader;
import org.fabric3.fabric.xml.DocumentLoaderImpl;
import org.fabric3.host.RuntimeMode;
import org.fabric3.host.monitor.MonitorConfigurationException;
import org.fabric3.host.runtime.ParseException;
import org.fabric3.host.stream.Source;
import org.fabric3.host.stream.UrlSource;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SystemConfigLoader {
    private static final URI DEFAULT_DOMAIN = URI.create("fabric3://domain");
    private static final String DEFAULT_ZONE = "default.zone";
    private DocumentLoader loader = new DocumentLoaderImpl();

    public Document loadSystemConfig(File configDirectory) throws ParseException {
        File systemConfig = new File(configDirectory, "systemConfig.xml");
        if (systemConfig.exists()) {
            try {
                URL url = systemConfig.toURI().toURL();
                UrlSource source = new UrlSource(url);
                return this.loadSystemConfig((Source)source);
            }
            catch (MalformedURLException e) {
                throw new ParseException((Throwable)e);
            }
        }
        return this.createDefaultSystemConfig();
    }

    public Document loadSystemConfig(Source source) throws ParseException {
        try {
            InputSource inputSource = new InputSource(source.openStream());
            Document document = this.loader.load(inputSource, true);
            Element oldRoot = document.getDocumentElement();
            boolean hasNamespaces = oldRoot.getNamespaceURI() != null && !"".equals(oldRoot.getNamespaceURI());
            Element newRoot = document.createElementNS("urn:fabric3.org", "values");
            newRoot.setAttribute("xmlns:sca", "http://docs.oasis-open.org/ns/opencsa/sca/200912");
            document.removeChild(oldRoot);
            document.appendChild(newRoot);
            newRoot.appendChild(oldRoot);
            if (!hasNamespaces) {
                this.loader.addNamespace(document, oldRoot, "urn:fabric3.org");
            }
            return document;
        }
        catch (IOException e) {
            throw new ParseException((Throwable)e);
        }
        catch (SAXException e) {
            throw new ParseException((Throwable)e);
        }
    }

    public Document createDefaultSystemConfig() {
        try {
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            factory.setNamespaceAware(true);
            Document document = factory.newDocumentBuilder().newDocument();
            Element root = document.createElement("values");
            document.appendChild(root);
            Element config = document.createElement("config");
            root.appendChild(config);
            return document;
        }
        catch (ParserConfigurationException e) {
            throw new AssertionError((Object)e);
        }
    }

    public URI parseDomainName(Document systemConfig) throws ParseException {
        Element root = systemConfig.getDocumentElement();
        NodeList nodes = root.getElementsByTagName("runtime");
        if (nodes.getLength() == 1) {
            Element node = (Element)nodes.item(0);
            String name = node.getAttribute("domain");
            if (name.length() > 0) {
                try {
                    URI uri = new URI("fabric3://" + name);
                    if (uri.getHost() == null) {
                        throw new ParseException("Invalid domain name specified in system configuration. Domain names must be a valid URI host.");
                    }
                    return uri;
                }
                catch (URISyntaxException e) {
                    throw new ParseException("Invalid domain name specified in system configuration", (Throwable)e);
                }
            }
            return DEFAULT_DOMAIN;
        }
        if (nodes.getLength() == 0) {
            return DEFAULT_DOMAIN;
        }
        throw new ParseException("Invalid system configuration: more than one <runtime> element specified");
    }

    public String parseZoneName(Document systemConfig) throws ParseException {
        Element root = systemConfig.getDocumentElement();
        NodeList nodes = root.getElementsByTagName("zoneName");
        if (nodes.getLength() == 1) {
            Element node = (Element)nodes.item(0);
            String name = node.getTextContent();
            if (name != null) {
                name = name.trim();
            }
            return name;
        }
        if (nodes.getLength() == 0) {
            return DEFAULT_ZONE;
        }
        throw new ParseException("Invalid system configuration: more than one <runtime> element specified");
    }

    public RuntimeMode parseRuntimeMode(Document systemConfig) throws ParseException {
        Element root = systemConfig.getDocumentElement();
        NodeList nodes = root.getElementsByTagName("runtime");
        if (nodes.getLength() == 1) {
            Element node = (Element)nodes.item(0);
            String name = node.getAttribute("mode");
            if ("controller".equalsIgnoreCase(name)) {
                return RuntimeMode.CONTROLLER;
            }
            if ("participant".equalsIgnoreCase(name)) {
                return RuntimeMode.PARTICIPANT;
            }
        }
        return RuntimeMode.VM;
    }

    public String parseEnvironment(Document systemConfig) {
        Element node;
        String environment;
        Element root = systemConfig.getDocumentElement();
        NodeList nodes = root.getElementsByTagName("runtime");
        if (nodes.getLength() == 1 && (environment = (node = (Element)nodes.item(0)).getAttribute("environment")).length() > 0) {
            return environment;
        }
        return "production";
    }

    public Element getMonitorConfiguration(String elementName, Document systemConfig) throws MonitorConfigurationException {
        Element root = systemConfig.getDocumentElement();
        NodeList nodes = "ROOT".equals(elementName) ? root.getElementsByTagName("runtime.monitor") : root.getElementsByTagName(elementName);
        if (nodes.getLength() == 1) {
            Element monitorElement = (Element)nodes.item(0);
            NodeList configurationElements = monitorElement.getElementsByTagName("configuration");
            if (configurationElements.getLength() != 1) {
                throw new MonitorConfigurationException("Invalid system configuration: Only one monitor <configuration> element must be specified");
            }
            Element element = (Element)configurationElements.item(0);
            this.addAppenderReferences(systemConfig, elementName, element);
            return element;
        }
        if (nodes.getLength() == 0) {
            return null;
        }
        throw new MonitorConfigurationException("Invalid system configuration: more than one <monitor> element specified");
    }

    public List<File> parseDeployDirectories(Document systemConfig) {
        ArrayList<File> files = new ArrayList<File>();
        Element root = systemConfig.getDocumentElement();
        NodeList nodes = root.getElementsByTagName("deploy.directory");
        for (int i = 0; i < nodes.getLength(); ++i) {
            Element element = (Element)nodes.item(i);
            File file = new File(element.getTextContent());
            files.add(file);
        }
        return files;
    }

    private void addAppenderReferences(Document systemConfig, String loggerName, Element element) {
        NodeList elements = element.getElementsByTagName("appender");
        ArrayList<Element> added = new ArrayList<Element>();
        for (int i = 0; i < elements.getLength(); ++i) {
            Node node = elements.item(i);
            Node nameAttribute = node.getAttributes().getNamedItem("name");
            if (nameAttribute == null) continue;
            String name = nameAttribute.getNodeValue();
            Element reference = systemConfig.createElement("appender-ref");
            reference.setAttribute("ref", name);
            added.add(reference);
        }
        if (!added.isEmpty()) {
            Element root = systemConfig.createElement("logger");
            root.setAttribute("name", loggerName);
            element.appendChild(root);
            for (Element reference : added) {
                root.appendChild(reference);
            }
        }
    }
}

