/*
 * Decompiled with CFR 0.152.
 */
package org.fabric3.fabric.security;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.cert.CertificateException;
import org.fabric3.host.runtime.HostInfo;
import org.fabric3.spi.security.KeyStoreManager;
import org.oasisopen.sca.annotation.EagerInit;
import org.oasisopen.sca.annotation.Init;
import org.oasisopen.sca.annotation.Property;
import org.oasisopen.sca.annotation.Reference;

@EagerInit
public class KeyStoreManagerImpl
implements KeyStoreManager {
    private HostInfo info;
    private String keyStoreLocationProperty = "javax.net.ssl.keyStore";
    private String keyStoreLocation;
    private String keyStorePasswordProperty = "javax.net.ssl.keyStorePassword";
    private String keyStorePassword;
    private String trustStoreLocation;
    private String trustStoreLocationProperty = "javax.net.ssl.trustStore";
    private String trustStorePassword;
    private String trustStorePasswordProperty = "javax.net.ssl.trustStorePassword";
    private File keystoreFile;
    private File truststoreFile;
    private String certPassword;
    private String trustStoreType = "JKS";
    private String keyStoreType = "JKS";
    private KeyStore keyStore;
    private KeyStore trustStore;

    public KeyStoreManagerImpl(@Reference HostInfo info) {
        this.info = info;
    }

    @Property(required=false)
    public void setKeyStoreLocationProperty(String keyStoreLocationProperty) {
        this.keyStoreLocationProperty = keyStoreLocationProperty;
    }

    @Property(required=false)
    public void setKeyStorePasswordProperty(String keyStorePasswordProperty) {
        this.keyStorePasswordProperty = keyStorePasswordProperty;
    }

    @Property(required=false)
    public void setTrustStoreLocationProperty(String trustStoreLocationProperty) {
        this.trustStoreLocationProperty = trustStoreLocationProperty;
    }

    @Property(required=false)
    public void setTrustStorePasswordProperty(String trustStorePasswordProperty) {
        this.trustStorePasswordProperty = trustStorePasswordProperty;
    }

    @Property(required=false)
    public void setKeyStoreLocation(String keyStoreLocation) {
        this.keyStoreLocation = keyStoreLocation;
    }

    @Property(required=false)
    public void setKeyStorePassword(String keyStorePassword) {
        this.keyStorePassword = keyStorePassword;
    }

    @Property(required=false)
    public void setTrustStoreLocation(String trustStoreLocation) {
        this.trustStoreLocation = trustStoreLocation;
    }

    @Property(required=false)
    public void setTrustStorePassword(String trustStorePassword) {
        this.trustStorePassword = trustStorePassword;
    }

    @Property(required=false)
    public void setCertPassword(String certPassword) {
        this.certPassword = certPassword;
    }

    @Property(required=false)
    public void setKeyStoreType(String keyStoreType) {
        this.keyStoreType = keyStoreType;
    }

    @Property(required=false)
    public void setTrustStoreType(String trustStoreType) {
        this.trustStoreType = trustStoreType;
    }

    @Init
    public void init() throws IOException, KeyStoreException, NoSuchAlgorithmException, CertificateException {
        this.initializeKeystore();
        this.initializeTrustStore();
    }

    public KeyStore getKeyStore() {
        return this.keyStore;
    }

    public KeyStore getTrustStore() {
        return this.trustStore;
    }

    public String getKeyStorePassword() {
        return this.keyStorePassword;
    }

    public File getKeyStoreLocation() {
        return this.keystoreFile;
    }

    public String getTrustStorePassword() {
        return this.trustStorePassword;
    }

    public File getTrustStoreLocation() {
        return this.truststoreFile;
    }

    public String getCertPassword() {
        return this.certPassword;
    }

    private void initializeKeystore() throws IOException, KeyStoreException, NoSuchAlgorithmException, CertificateException {
        File dir;
        this.keystoreFile = null;
        if (this.keyStoreLocation == null) {
            dir = this.info.getBaseDir();
            if (dir != null) {
                this.keystoreFile = new File(dir, "config" + File.separator + "fabric3-keystore.jks");
                this.keyStoreLocation = this.keystoreFile.getAbsolutePath();
            }
        } else {
            this.keystoreFile = new File(this.keyStoreLocation);
            if (!this.keystoreFile.isAbsolute()) {
                dir = this.info.getBaseDir();
                this.keystoreFile = new File(dir, "config" + File.separator + this.keyStoreLocation);
                this.keyStoreLocation = this.keystoreFile.getAbsolutePath();
            }
        }
        if (this.keyStorePassword != null) {
            System.setProperty(this.keyStorePasswordProperty, this.keyStorePassword);
        }
        if (this.keystoreFile != null && this.keystoreFile.exists()) {
            System.setProperty(this.keyStoreLocationProperty, this.keystoreFile.getAbsolutePath());
            char[] keyStorePasswordChars = null;
            if (this.keyStorePassword != null) {
                keyStorePasswordChars = this.keyStorePassword.toCharArray();
            }
            this.keyStore = KeyStore.getInstance(this.keyStoreType);
            FileInputStream stream = new FileInputStream(this.keyStoreLocation);
            this.keyStore.load(stream, keyStorePasswordChars);
        }
    }

    private void initializeTrustStore() throws IOException, KeyStoreException, NoSuchAlgorithmException, CertificateException {
        this.truststoreFile = null;
        if (this.trustStoreLocation == null) {
            File dir = this.info.getBaseDir();
            if (dir != null) {
                this.truststoreFile = new File(dir, "config" + File.separator + "fabric3-keystore.jks");
                this.trustStoreLocation = this.truststoreFile.getAbsolutePath();
                this.trustStorePassword = this.keyStorePassword;
            } else if (this.keyStoreLocation != null) {
                this.truststoreFile = this.keystoreFile;
                this.trustStoreLocation = this.keyStoreLocation;
                this.trustStorePassword = this.keyStorePassword;
            }
        } else {
            this.truststoreFile = new File(this.trustStoreLocation);
        }
        if (this.trustStorePassword != null) {
            System.setProperty(this.trustStorePasswordProperty, this.trustStorePassword);
        }
        if (this.truststoreFile != null && this.truststoreFile.exists()) {
            System.setProperty(this.trustStoreLocationProperty, this.truststoreFile.getAbsolutePath());
            this.trustStore = KeyStore.getInstance(this.trustStoreType);
            FileInputStream stream = new FileInputStream(this.trustStoreLocation);
            char[] trustStorePasswordChars = null;
            if (this.trustStorePassword != null) {
                trustStorePasswordChars = this.trustStorePassword.toCharArray();
            }
            this.trustStore.load(stream, trustStorePasswordChars);
        }
    }
}

