/*
 * Decompiled with CFR 0.152.
 */
package org.fabric3.fabric.synthesizer;

import java.net.URI;
import org.fabric3.fabric.instantiator.AtomicComponentInstantiator;
import org.fabric3.fabric.instantiator.InstantiationContext;
import org.fabric3.host.Names;
import org.fabric3.host.domain.AssemblyException;
import org.fabric3.implementation.system.model.SystemImplementation;
import org.fabric3.implementation.system.singleton.SingletonComponent;
import org.fabric3.implementation.system.singleton.SingletonImplementation;
import org.fabric3.model.type.component.ComponentDefinition;
import org.fabric3.model.type.component.ComponentType;
import org.fabric3.model.type.component.Implementation;
import org.fabric3.model.type.component.Scope;
import org.fabric3.model.type.component.ServiceDefinition;
import org.fabric3.model.type.contract.ServiceContract;
import org.fabric3.spi.cm.ComponentManager;
import org.fabric3.spi.cm.RegistrationException;
import org.fabric3.spi.component.Component;
import org.fabric3.spi.component.InstanceLifecycleException;
import org.fabric3.spi.component.ScopeContainer;
import org.fabric3.spi.component.ScopeRegistry;
import org.fabric3.spi.component.ScopedComponent;
import org.fabric3.spi.introspection.DefaultIntrospectionContext;
import org.fabric3.spi.introspection.IntrospectionContext;
import org.fabric3.spi.introspection.java.ImplementationProcessor;
import org.fabric3.spi.introspection.java.contract.JavaContractProcessor;
import org.fabric3.spi.invocation.WorkContext;
import org.fabric3.spi.lcm.LogicalComponentManager;
import org.fabric3.spi.model.instance.LogicalComponent;
import org.fabric3.spi.model.instance.LogicalCompositeComponent;
import org.fabric3.spi.model.instance.LogicalReference;
import org.fabric3.spi.model.instance.LogicalState;
import org.fabric3.spi.model.instance.LogicalWire;
import org.fabric3.spi.model.type.java.InjectingComponentType;
import org.fabric3.spi.model.type.java.JavaServiceContract;
import org.fabric3.spi.synthesize.ComponentRegistrationException;
import org.fabric3.spi.synthesize.ComponentSynthesizer;
import org.fabric3.spi.synthesize.InvalidServiceContractException;
import org.oasisopen.sca.annotation.Constructor;
import org.oasisopen.sca.annotation.Reference;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SingletonComponentSynthesizer
implements ComponentSynthesizer {
    private ImplementationProcessor implementationProcessor;
    private AtomicComponentInstantiator instantiator;
    private LogicalComponentManager lcm;
    private ComponentManager componentManager;
    private JavaContractProcessor contractProcessor;
    private ScopeContainer scopeContainer;

    @Constructor
    public SingletonComponentSynthesizer(@Reference ImplementationProcessor implementationProcessor, @Reference AtomicComponentInstantiator instantiator, @Reference LogicalComponentManager lcm, @Reference ComponentManager componentManager, @Reference JavaContractProcessor contractProcessor, @Reference ScopeRegistry registry) {
        this(implementationProcessor, instantiator, lcm, componentManager, contractProcessor, registry.getScopeContainer(Scope.COMPOSITE));
    }

    public SingletonComponentSynthesizer(ImplementationProcessor implementationProcessor, AtomicComponentInstantiator instantiator, LogicalComponentManager lcm, ComponentManager componentManager, JavaContractProcessor contractProcessor, ScopeContainer scopeContainer) {
        this.implementationProcessor = implementationProcessor;
        this.instantiator = instantiator;
        this.lcm = lcm;
        this.componentManager = componentManager;
        this.contractProcessor = contractProcessor;
        this.scopeContainer = scopeContainer;
    }

    public <S, I extends S> void registerComponent(String name, Class<S> type, I instance, boolean introspect) throws ComponentRegistrationException {
        try {
            LogicalComponent<?> logical = this.createLogicalComponent(name, type, instance, introspect);
            ScopedComponent physical = this.createPhysicalComponent(logical, instance);
            this.componentManager.register((Component)physical);
            this.scopeContainer.register(physical);
            WorkContext workContext = new WorkContext();
            this.scopeContainer.getInstance(physical, workContext);
        }
        catch (RegistrationException e) {
            throw new ComponentRegistrationException((Throwable)e);
        }
        catch (AssemblyException e) {
            throw new ComponentRegistrationException((Throwable)e);
        }
        catch (InstanceLifecycleException e) {
            throw new ComponentRegistrationException((Throwable)e);
        }
    }

    private <S, I extends S> LogicalComponent<?> createLogicalComponent(String name, Class<S> type, I instance, boolean introspect) throws InvalidServiceContractException, AssemblyException {
        LogicalCompositeComponent domain = this.lcm.getRootComponent();
        ComponentDefinition<Implementation<?>> definition = this.createDefinition(name, type, instance, introspect);
        InstantiationContext context = new InstantiationContext();
        LogicalComponent<?> logical = this.instantiator.instantiate(definition, domain, context);
        logical.setAutowire(domain.getAutowire());
        if (context.hasErrors()) {
            throw new AssemblyException(context.getErrors());
        }
        logical.setState(LogicalState.PROVISIONED);
        for (LogicalReference reference : logical.getReferences()) {
            reference.setResolved(true);
            for (LogicalWire wire : reference.getWires()) {
                wire.setState(LogicalState.PROVISIONED);
            }
        }
        return logical;
    }

    private <S, I extends S> ComponentDefinition<Implementation<?>> createDefinition(String name, Class<S> type, I instance, boolean introspect) throws InvalidServiceContractException {
        String implClassName = instance.getClass().getName();
        ClassLoader loader = this.getClass().getClassLoader();
        DefaultIntrospectionContext context = new DefaultIntrospectionContext(Names.BOOT_CONTRIBUTION, loader);
        if (introspect) {
            SystemImplementation implementation = new SystemImplementation();
            implementation.setImplementationClass(implClassName);
            InjectingComponentType componentType = this.implementationProcessor.introspect(implClassName, (IntrospectionContext)context);
            implementation.setComponentType((ComponentType)componentType);
            ComponentDefinition def = new ComponentDefinition(name);
            SingletonImplementation singletonImplementation = new SingletonImplementation((InjectingComponentType)implementation.getComponentType(), implClassName);
            def.setImplementation((Implementation)singletonImplementation);
            def.setContributionUri(Names.BOOT_CONTRIBUTION);
            return def;
        }
        JavaServiceContract contract = this.contractProcessor.introspect(type, (IntrospectionContext)context);
        if (context.hasErrors()) {
            throw new InvalidServiceContractException(context.getErrors());
        }
        String serviceName = contract.getInterfaceName();
        ServiceDefinition service = new ServiceDefinition(serviceName, (ServiceContract)contract);
        InjectingComponentType componentType = new InjectingComponentType(implClassName);
        componentType.add(service);
        SingletonImplementation implementation = new SingletonImplementation(componentType, implClassName);
        implementation.setComponentType((ComponentType)componentType);
        ComponentDefinition def = new ComponentDefinition(name);
        def.setImplementation((Implementation)implementation);
        def.setContributionUri(Names.BOOT_CONTRIBUTION);
        return def;
    }

    private <I> ScopedComponent createPhysicalComponent(LogicalComponent<?> logicalComponent, I instance) {
        URI uri = logicalComponent.getUri();
        InjectingComponentType type = (InjectingComponentType)logicalComponent.getDefinition().getComponentType();
        type.getInjectionSites();
        SingletonComponent component = new SingletonComponent(uri, instance, type.getInjectionSites());
        component.setClassLoaderId(Names.BOOT_CONTRIBUTION);
        return component;
    }
}

