/*
 * Decompiled with CFR 0.152.
 */
package org.fabric3.fabric.transport;

import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import org.fabric3.api.annotation.management.Management;
import org.fabric3.api.annotation.management.ManagementOperation;
import org.fabric3.api.annotation.management.OperationType;
import org.fabric3.api.annotation.monitor.Monitor;
import org.fabric3.fabric.transport.TransportServiceMonitor;
import org.fabric3.spi.transport.Transport;
import org.oasisopen.sca.annotation.EagerInit;
import org.oasisopen.sca.annotation.Reference;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@EagerInit
@Management(path="/runtime/transports", description="Manages runtime binding transports")
public class TransportService {
    private TransportServiceMonitor monitor;
    private Map<String, Transport> transports = Collections.emptyMap();

    public TransportService(@Monitor TransportServiceMonitor monitor) {
        this.monitor = monitor;
    }

    @Reference(required=false)
    public void setTransports(Map<String, Transport> transports) {
        this.transports = transports;
    }

    @ManagementOperation(path="/")
    public Collection<String> getTransports() {
        return this.transports.keySet();
    }

    @ManagementOperation(type=OperationType.DELETE, description="Suspend a transport from receiving requests")
    public void suspend(String name) {
        Transport transport = this.transports.get(name);
        if (transport == null) {
            this.monitor.transportNotFound(name);
            return;
        }
        transport.suspend();
    }

    @ManagementOperation(type=OperationType.DELETE, description="Suspend all transports from receiving requests")
    public void suspendAll() {
        for (Transport transport : this.transports.values()) {
            transport.suspend();
        }
    }

    @ManagementOperation(type=OperationType.POST, description="Resume receiving requests for a transport")
    public void resume(String name) {
        Transport transport = this.transports.get(name);
        if (transport == null) {
            this.monitor.transportNotFound(name);
            return;
        }
        transport.resume();
    }

    @ManagementOperation(type=OperationType.POST, description="Resume receiving requests for all transports")
    public void resumeAll() {
        for (Transport transport : this.transports.values()) {
            transport.resume();
        }
    }
}

