/*
 * Decompiled with CFR 0.152.
 */
package org.fabric3.tx;

import javax.transaction.HeuristicMixedException;
import javax.transaction.HeuristicRollbackException;
import javax.transaction.InvalidTransactionException;
import javax.transaction.NotSupportedException;
import javax.transaction.RollbackException;
import javax.transaction.SystemException;
import javax.transaction.Transaction;
import javax.transaction.TransactionManager;
import org.fabric3.tx.TxAction;
import org.fabric3.tx.TxMonitor;
import org.oasisopen.sca.ServiceRuntimeException;

public abstract class AbstractTxSupport {
    protected TransactionManager transactionManager;
    protected TxAction txAction;
    protected TxMonitor monitor;

    public AbstractTxSupport(TransactionManager transactionManager, TxAction txAction, TxMonitor monitor) {
        this.transactionManager = transactionManager;
        this.txAction = txAction;
        this.monitor = monitor;
    }

    protected void setRollbackOnly() throws ServiceRuntimeException {
        try {
            this.monitor.markedForRollback(Thread.currentThread().getName());
            this.transactionManager.setRollbackOnly();
        }
        catch (SystemException e) {
            throw new ServiceRuntimeException((Throwable)e);
        }
    }

    protected Transaction getTransaction() throws ServiceRuntimeException {
        try {
            return this.transactionManager.getTransaction();
        }
        catch (SystemException e) {
            throw new ServiceRuntimeException((Throwable)e);
        }
    }

    protected void rollback() throws ServiceRuntimeException {
        try {
            this.monitor.rolledback(Thread.currentThread().getName());
            this.transactionManager.rollback();
        }
        catch (SystemException e) {
            throw new ServiceRuntimeException((Throwable)e);
        }
    }

    protected void begin() throws ServiceRuntimeException {
        try {
            this.transactionManager.begin();
        }
        catch (NotSupportedException e) {
            throw new ServiceRuntimeException((Throwable)e);
        }
        catch (SystemException e) {
            throw new ServiceRuntimeException((Throwable)e);
        }
    }

    protected void suspend() throws ServiceRuntimeException {
        try {
            this.transactionManager.suspend();
        }
        catch (SystemException e) {
            throw new ServiceRuntimeException((Throwable)e);
        }
    }

    protected void resume(Transaction transaction) throws ServiceRuntimeException {
        try {
            this.transactionManager.resume(transaction);
        }
        catch (SystemException e) {
            throw new ServiceRuntimeException((Throwable)e);
        }
        catch (InvalidTransactionException e) {
            throw new ServiceRuntimeException((Throwable)e);
        }
        catch (IllegalStateException e) {
            throw new ServiceRuntimeException((Throwable)e);
        }
    }

    protected void commit() throws ServiceRuntimeException {
        try {
            if (this.transactionManager.getStatus() != 1) {
                this.transactionManager.commit();
            } else {
                this.rollback();
            }
        }
        catch (SystemException e) {
            throw new ServiceRuntimeException((Throwable)e);
        }
        catch (IllegalStateException e) {
            throw new ServiceRuntimeException((Throwable)e);
        }
        catch (SecurityException e) {
            throw new ServiceRuntimeException((Throwable)e);
        }
        catch (HeuristicMixedException e) {
            throw new ServiceRuntimeException((Throwable)e);
        }
        catch (HeuristicRollbackException e) {
            throw new ServiceRuntimeException((Throwable)e);
        }
        catch (RollbackException e) {
            throw new ServiceRuntimeException((Throwable)e);
        }
    }
}

