/*
 * Decompiled with CFR 0.152.
 */
package org.fabric3.tx;

import javax.transaction.Transaction;
import javax.transaction.TransactionManager;
import org.fabric3.spi.invocation.Message;
import org.fabric3.spi.wire.Interceptor;
import org.fabric3.tx.AbstractTxSupport;
import org.fabric3.tx.TxAction;
import org.fabric3.tx.TxMonitor;

public class TxInterceptor
extends AbstractTxSupport
implements Interceptor {
    private Interceptor next;

    public TxInterceptor(TransactionManager tm, TxAction action, TxMonitor monitor) {
        super(tm, action, monitor);
    }

    public Interceptor getNext() {
        return this.next;
    }

    public void setNext(Interceptor next) {
        this.next = next;
    }

    public Message invoke(Message message) {
        Message ret;
        Transaction transaction = this.getTransaction();
        if (this.txAction == TxAction.BEGIN) {
            if (transaction == null) {
                this.begin();
            }
        } else if (this.txAction == TxAction.SUSPEND && transaction != null) {
            this.suspend();
        }
        try {
            ret = this.next.invoke(message);
        }
        catch (RuntimeException e) {
            if (this.txAction == TxAction.BEGIN && transaction == null) {
                this.rollback();
            } else if (this.txAction == TxAction.SUSPEND && transaction != null) {
                this.monitor.resumeOnError(e);
                this.resume(transaction);
            }
            throw e;
        }
        if (this.txAction == TxAction.BEGIN && transaction == null && !ret.isFault()) {
            this.commit();
        } else if (this.txAction == TxAction.BEGIN && transaction == null && ret.isFault()) {
            this.rollback();
        } else if (this.txAction == TxAction.SUSPEND && transaction != null) {
            this.resume(transaction);
        }
        return ret;
    }
}

