/*
 * Decompiled with CFR 0.152.
 */
package org.fabric3.async.runtime;

import java.util.List;
import java.util.Map;
import org.fabric3.api.SecuritySubject;
import org.fabric3.async.runtime.NonBlockingMonitor;
import org.fabric3.spi.invocation.CallFrame;
import org.fabric3.spi.invocation.Message;
import org.fabric3.spi.invocation.WorkContext;
import org.fabric3.spi.wire.Interceptor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AsyncRequest
implements Runnable {
    private final Interceptor next;
    private final Message message;
    private SecuritySubject subject;
    private List<CallFrame> stack;
    private Map<String, Object> headers;
    private NonBlockingMonitor monitor;

    public AsyncRequest(Interceptor next, Message message, SecuritySubject subject, List<CallFrame> stack, Map<String, Object> headers, NonBlockingMonitor monitor) {
        this.next = next;
        this.message = message;
        this.subject = subject;
        this.stack = stack;
        this.headers = headers;
        this.monitor = monitor;
    }

    @Override
    public void run() {
        WorkContext newWorkContext = new WorkContext();
        if (this.stack != null) {
            newWorkContext.addCallFrames(this.stack);
        }
        if (this.headers != null) {
            newWorkContext.addHeaders(this.headers);
        }
        newWorkContext.setSubject(this.subject);
        this.message.setWorkContext(newWorkContext);
        Message ret = this.next.invoke(this.message);
        if (ret.isFault()) {
            this.monitor.onError((Throwable)ret.getBody());
        }
    }

    public Interceptor getNext() {
        return this.next;
    }

    public Message getMessage() {
        return this.message;
    }
}

