/*
 * Decompiled with CFR 0.152.
 */
package org.fabric3.introspection.xml;

import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import org.fabric3.host.stream.Source;
import org.fabric3.spi.introspection.IntrospectionContext;
import org.fabric3.spi.introspection.xml.LoaderException;
import org.fabric3.spi.introspection.xml.LoaderRegistry;
import org.fabric3.spi.introspection.xml.TypeLoader;
import org.fabric3.spi.introspection.xml.UnrecognizedElementException;
import org.fabric3.spi.xml.XMLFactory;
import org.oasisopen.sca.annotation.EagerInit;
import org.oasisopen.sca.annotation.Reference;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@EagerInit
public class LoaderRegistryImpl
implements LoaderRegistry {
    private final XMLInputFactory xmlFactory;
    private Map<QName, TypeLoader<?>> mappedLoaders = new HashMap();
    private final Map<QName, TypeLoader<?>> loaders = new HashMap();

    public LoaderRegistryImpl(@Reference XMLFactory factory) {
        this.xmlFactory = factory.newInputFactoryInstance();
    }

    @Reference(required=false)
    public void setLoaders(Map<QName, TypeLoader<?>> mappedLoaders) {
        this.mappedLoaders = mappedLoaders;
    }

    public void registerLoader(QName element, TypeLoader<?> loader) {
        if (this.loaders.containsKey(element)) {
            throw new IllegalStateException("Loader already registered for " + element);
        }
        this.loaders.put(element, loader);
    }

    public void unregisterLoader(QName element) {
        this.loaders.remove(element);
    }

    public <O> O load(XMLStreamReader reader, Class<O> type, IntrospectionContext introspectionContext) throws XMLStreamException, UnrecognizedElementException {
        QName name = reader.getName();
        TypeLoader<?> loader = this.loaders.get(name);
        if (loader == null) {
            loader = this.mappedLoaders.get(name);
        }
        if (loader == null) {
            throw new UnrecognizedElementException(reader);
        }
        return type.cast(loader.load(reader, introspectionContext));
    }

    public <O> O load(Source source, Class<O> type, IntrospectionContext ctx) throws LoaderException {
        InputStream stream;
        String id = source.getSystemId();
        try {
            stream = source.openStream();
        }
        catch (IOException e) {
            throw new LoaderException("Invalid source: " + id, (Throwable)e);
        }
        try {
            O e = this.load(id, stream, type, ctx);
        }
        catch (XMLStreamException e) {
            throw new LoaderException("Invalid source: " + id, (Throwable)e);
        }
        finally {
            try {
                stream.close();
            }
            catch (IOException e) {}
        }
        return e;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <O> O load(String id, InputStream stream, Class<O> type, IntrospectionContext ctx) throws XMLStreamException, UnrecognizedElementException {
        XMLStreamReader reader = this.isURL(id) ? this.xmlFactory.createXMLStreamReader(id, stream) : this.xmlFactory.createXMLStreamReader(stream);
        reader.nextTag();
        O o = this.load(reader, type, ctx);
        return o;
        finally {
            if (reader != null) {
                try {
                    reader.close();
                }
                catch (XMLStreamException e) {}
            }
        }
    }

    private boolean isURL(String path) {
        try {
            new URL(path);
            return true;
        }
        catch (MalformedURLException ex) {
            return false;
        }
    }
}

