/*
 * Decompiled with CFR 0.152.
 */
package org.fabric3.introspection.xml.binding;

import java.net.URI;
import java.net.URISyntaxException;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import org.fabric3.host.contribution.ValidationFailure;
import org.fabric3.spi.introspection.IntrospectionContext;
import org.fabric3.spi.introspection.xml.AbstractValidatingTypeLoader;
import org.fabric3.spi.introspection.xml.InvalidValue;
import org.fabric3.spi.model.type.binding.BindingHandlerDefinition;
import org.oasisopen.sca.annotation.EagerInit;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@EagerInit
public class BindingHandlerLoader
extends AbstractValidatingTypeLoader<BindingHandlerDefinition> {
    private static final BindingHandlerDefinition INVALID_DEFINITION = new BindingHandlerDefinition(URI.create("Invalid"));

    public BindingHandlerLoader() {
        this.addAttributes(new String[]{"target"});
    }

    public BindingHandlerDefinition load(XMLStreamReader reader, IntrospectionContext context) throws XMLStreamException {
        this.validateAttributes(reader, context);
        String target = reader.getAttributeValue(null, "target");
        if (target == null || "".equals(target)) {
            InvalidValue error = new InvalidValue("Target attribute is not specified", reader);
            context.addError((ValidationFailure)error);
            return INVALID_DEFINITION;
        }
        try {
            URI targetUri = new URI(target);
            return new BindingHandlerDefinition(targetUri);
        }
        catch (URISyntaxException e) {
            InvalidValue error = new InvalidValue("Target attribute is not a valid URI: " + target, reader);
            context.addError((ValidationFailure)error);
            return INVALID_DEFINITION;
        }
    }
}

