/*
 * Decompiled with CFR 0.152.
 */
package org.fabric3.introspection.xml.binding;

import javax.xml.namespace.QName;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import org.fabric3.host.contribution.ValidationFailure;
import org.fabric3.introspection.xml.common.AbstractExtensibleTypeLoader;
import org.fabric3.model.type.ModelObject;
import org.fabric3.model.type.PolicyAware;
import org.fabric3.model.type.component.Target;
import org.fabric3.spi.introspection.IntrospectionContext;
import org.fabric3.spi.introspection.xml.InvalidTargetException;
import org.fabric3.spi.introspection.xml.InvalidValue;
import org.fabric3.spi.introspection.xml.LoaderHelper;
import org.fabric3.spi.introspection.xml.LoaderRegistry;
import org.fabric3.spi.introspection.xml.UnrecognizedElement;
import org.fabric3.spi.introspection.xml.UnrecognizedElementException;
import org.fabric3.spi.model.type.binding.SCABinding;
import org.oasisopen.sca.annotation.Reference;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SCABindingLoader
extends AbstractExtensibleTypeLoader<SCABinding> {
    private static final QName BINDING = new QName("http://docs.oasis-open.org/ns/opencsa/sca/200912", "binding.sca");
    private LoaderRegistry registry;
    private LoaderHelper helper;

    public SCABindingLoader(@Reference LoaderRegistry registry, @Reference LoaderHelper helper) {
        super(registry);
        this.registry = registry;
        this.helper = helper;
        this.addAttributes(new String[]{"uri", "requires", "policySets", "name"});
    }

    @Override
    public QName getXMLType() {
        return BINDING;
    }

    public SCABinding load(XMLStreamReader reader, IntrospectionContext context) throws XMLStreamException {
        this.validateAttributes(reader, context);
        Target target = null;
        String uriAttr = reader.getAttributeValue(null, "uri");
        if (uriAttr != null) {
            try {
                target = this.helper.parseTarget(uriAttr, reader);
            }
            catch (InvalidTargetException e) {
                InvalidValue error = new InvalidValue("Invalid URI specified on binding.sca", reader);
                context.addError((ValidationFailure)error);
            }
        }
        String name = reader.getAttributeValue(null, "name");
        SCABinding binding = new SCABinding(name, target);
        this.helper.loadPolicySetsAndIntents((PolicyAware)binding, reader, context);
        while (true) {
            switch (reader.next()) {
                case 1: {
                    try {
                        this.registry.load(reader, ModelObject.class, context);
                    }
                    catch (UnrecognizedElementException e) {
                        UnrecognizedElement error = new UnrecognizedElement(reader);
                        context.addError((ValidationFailure)error);
                    }
                    break;
                }
                case 2: {
                    if (!"binding.sca".equals(reader.getName().getLocalPart())) break;
                    return binding;
                }
            }
        }
    }
}

