/*
 * Decompiled with CFR 0.152.
 */
package org.fabric3.introspection.xml.composite;

import java.net.URI;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import org.fabric3.host.contribution.ValidationFailure;
import org.fabric3.introspection.xml.common.AbstractExtensibleTypeLoader;
import org.fabric3.introspection.xml.common.BindingHelper;
import org.fabric3.model.type.ModelObject;
import org.fabric3.model.type.PolicyAware;
import org.fabric3.model.type.component.BindingDefinition;
import org.fabric3.model.type.component.ChannelDefinition;
import org.fabric3.spi.introspection.IntrospectionContext;
import org.fabric3.spi.introspection.xml.LoaderHelper;
import org.fabric3.spi.introspection.xml.LoaderRegistry;
import org.fabric3.spi.introspection.xml.MissingAttribute;
import org.fabric3.spi.introspection.xml.UnrecognizedElement;
import org.fabric3.spi.introspection.xml.UnrecognizedElementException;
import org.oasisopen.sca.annotation.EagerInit;
import org.oasisopen.sca.annotation.Property;
import org.oasisopen.sca.annotation.Reference;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@EagerInit
public class ChannelLoader
extends AbstractExtensibleTypeLoader<ChannelDefinition> {
    private static final QName CHANNEL = new QName("http://docs.oasis-open.org/ns/opencsa/sca/200912", "channel");
    private LoaderHelper loaderHelper;
    private boolean roundTrip;

    public ChannelLoader(@Reference LoaderRegistry registry, @Reference LoaderHelper loaderHelper) {
        super(registry);
        this.addAttributes(new String[]{"name", "requires"});
        this.loaderHelper = loaderHelper;
    }

    @Property(required=false)
    public void setRoundTrip(boolean roundTrip) {
        this.roundTrip = roundTrip;
    }

    public ChannelDefinition load(XMLStreamReader reader, IntrospectionContext context) throws XMLStreamException {
        this.validateAttributes(reader, context);
        String name = reader.getAttributeValue(null, "name");
        if (name == null) {
            MissingAttribute failure = new MissingAttribute("Component name not specified", reader);
            context.addError((ValidationFailure)failure);
            return null;
        }
        URI uri = context.getContributionUri();
        ChannelDefinition definition = new ChannelDefinition(name, uri);
        if (this.roundTrip) {
            definition.enableRoundTrip();
        }
        this.loaderHelper.loadPolicySetsAndIntents((PolicyAware)definition, reader, context);
        while (true) {
            switch (reader.next()) {
                case 1: {
                    ModelObject type;
                    QName elementName = reader.getName();
                    try {
                        type = (ModelObject)this.registry.load(reader, ModelObject.class, context);
                    }
                    catch (UnrecognizedElementException e) {
                        UnrecognizedElement failure = new UnrecognizedElement(reader);
                        context.addError((ValidationFailure)failure);
                        break;
                    }
                    if (type instanceof BindingDefinition) {
                        BindingDefinition binding = (BindingDefinition)type;
                        boolean check = BindingHelper.checkDuplicateNames(binding, definition.getBindings(), reader, context);
                        if (check) {
                            definition.addBinding(binding);
                        }
                    } else {
                        if (type == null) break;
                        context.addError((ValidationFailure)new UnrecognizedElement(reader));
                        break;
                    }
                    if (!reader.getName().equals(elementName) || reader.getEventType() != 2) {
                        throw new AssertionError((Object)"Loader must position the cursor to the end element");
                    }
                }
                case 2: {
                    QName elementName = reader.getName();
                    if (!CHANNEL.equals(elementName)) break;
                    return definition;
                }
            }
        }
    }

    @Override
    public QName getXMLType() {
        return CHANNEL;
    }
}

