/*
 * Decompiled with CFR 0.152.
 */
package org.fabric3.introspection.xml.composite;

import java.net.URI;
import java.util.Map;
import javax.xml.namespace.NamespaceContext;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import org.fabric3.host.contribution.ArtifactValidationFailure;
import org.fabric3.host.contribution.ValidationFailure;
import org.fabric3.introspection.xml.common.AbstractExtensibleTypeLoader;
import org.fabric3.introspection.xml.composite.DuplicateChannelName;
import org.fabric3.introspection.xml.composite.DuplicateComponentName;
import org.fabric3.introspection.xml.composite.DuplicateInclude;
import org.fabric3.introspection.xml.composite.DuplicatePromotedReference;
import org.fabric3.introspection.xml.composite.DuplicatePromotedService;
import org.fabric3.introspection.xml.composite.DuplicateProperty;
import org.fabric3.introspection.xml.composite.IllegalPromotion;
import org.fabric3.introspection.xml.composite.InvalidInclude;
import org.fabric3.introspection.xml.composite.PromotionNotFound;
import org.fabric3.introspection.xml.composite.StatefulNamespaceContext;
import org.fabric3.model.type.ModelObject;
import org.fabric3.model.type.PolicyAware;
import org.fabric3.model.type.component.Autowire;
import org.fabric3.model.type.component.ChannelDefinition;
import org.fabric3.model.type.component.ComponentDefinition;
import org.fabric3.model.type.component.ComponentReference;
import org.fabric3.model.type.component.ComponentType;
import org.fabric3.model.type.component.Composite;
import org.fabric3.model.type.component.CompositeReference;
import org.fabric3.model.type.component.CompositeService;
import org.fabric3.model.type.component.Implementation;
import org.fabric3.model.type.component.Include;
import org.fabric3.model.type.component.Multiplicity;
import org.fabric3.model.type.component.PropertyValue;
import org.fabric3.model.type.component.ReferenceDefinition;
import org.fabric3.model.type.component.ResourceDefinition;
import org.fabric3.model.type.component.ServiceDefinition;
import org.fabric3.model.type.component.WireDefinition;
import org.fabric3.model.type.contract.ServiceContract;
import org.fabric3.spi.contract.ContractMatcher;
import org.fabric3.spi.contract.MatchResult;
import org.fabric3.spi.introspection.DefaultIntrospectionContext;
import org.fabric3.spi.introspection.IntrospectionContext;
import org.fabric3.spi.introspection.xml.CompositeConstants;
import org.fabric3.spi.introspection.xml.IncompatibleContracts;
import org.fabric3.spi.introspection.xml.InvalidValue;
import org.fabric3.spi.introspection.xml.LoaderHelper;
import org.fabric3.spi.introspection.xml.LoaderRegistry;
import org.fabric3.spi.introspection.xml.MissingAttribute;
import org.fabric3.spi.introspection.xml.TypeLoader;
import org.fabric3.spi.introspection.xml.UnrecognizedElement;
import org.fabric3.spi.introspection.xml.UnrecognizedElementException;
import org.fabric3.spi.util.UriHelper;
import org.oasisopen.sca.annotation.Constructor;
import org.oasisopen.sca.annotation.EagerInit;
import org.oasisopen.sca.annotation.Property;
import org.oasisopen.sca.annotation.Reference;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@EagerInit
public class CompositeLoader
extends AbstractExtensibleTypeLoader<Composite> {
    private TypeLoader<CompositeService> serviceLoader;
    private TypeLoader<CompositeReference> referenceLoader;
    private TypeLoader<org.fabric3.model.type.component.Property> propertyLoader;
    private ContractMatcher contractMatcher;
    private final LoaderHelper loaderHelper;
    boolean roundTrip;

    public CompositeLoader(LoaderRegistry registry, TypeLoader<org.fabric3.model.type.component.Property> propertyLoader, LoaderHelper loaderHelper) {
        this(registry, null, null, propertyLoader, null, loaderHelper);
    }

    @Constructor
    public CompositeLoader(@Reference LoaderRegistry registry, @Reference(name="service") TypeLoader<CompositeService> serviceLoader, @Reference(name="reference") TypeLoader<CompositeReference> referenceLoader, @Reference(name="property") TypeLoader<org.fabric3.model.type.component.Property> propertyLoader, @Reference ContractMatcher contractMatcher, @Reference LoaderHelper loaderHelper) {
        super(registry);
        this.addAttributes(new String[]{"name", "autowire", "targetNamespace", "local", "requires", "policySets", "constrainingType", "channel", "schemaLocation"});
        this.serviceLoader = serviceLoader;
        this.referenceLoader = referenceLoader;
        this.propertyLoader = propertyLoader;
        this.contractMatcher = contractMatcher;
        this.loaderHelper = loaderHelper;
    }

    @Property(required=false)
    public void setRoundTrip(boolean roundTrip) {
        this.roundTrip = roundTrip;
    }

    @Override
    public QName getXMLType() {
        return CompositeConstants.COMPOSITE;
    }

    public Composite load(XMLStreamReader reader, IntrospectionContext context) throws XMLStreamException {
        this.validateAttributes(reader, context);
        String name = reader.getAttributeValue(null, "name");
        String targetNamespace = reader.getAttributeValue(null, "targetNamespace");
        String localStr = reader.getAttributeValue(null, "local");
        boolean local = Boolean.valueOf(localStr);
        DefaultIntrospectionContext childContext = new DefaultIntrospectionContext(context, targetNamespace);
        QName compositeName = new QName(targetNamespace, name);
        NamespaceContext nsContext = this.createNamespaceContext(reader);
        Composite type = new Composite(compositeName);
        String autowire = reader.getAttributeValue(null, "autowire");
        type.setAutowire(Autowire.fromString((String)autowire));
        if (this.roundTrip) {
            type.enableRoundTrip();
            this.addNamespaces(type, reader);
            if (targetNamespace != null) {
                type.attributeSpecified("targetNamespace");
            }
            if (localStr != null) {
                type.attributeSpecified("local");
            }
            if (autowire != null) {
                type.attributeSpecified("autowire");
            }
        }
        type.setContributionUri(context.getContributionUri());
        type.setLocal(local);
        this.loaderHelper.loadPolicySetsAndIntents((PolicyAware)type, reader, (IntrospectionContext)childContext);
        try {
            block7: while (true) {
                int val = reader.next();
                switch (val) {
                    case 1: {
                        QName qname = reader.getName();
                        if (CompositeConstants.INCLUDE.equals(qname)) {
                            this.handleInclude(type, reader, (IntrospectionContext)childContext);
                            continue block7;
                        }
                        if (CompositeConstants.PROPERTY.equals(qname)) {
                            this.handleProperty(type, reader, (IntrospectionContext)childContext);
                            continue block7;
                        }
                        if (CompositeConstants.SERVICE.equals(qname)) {
                            this.handleService(type, reader, (IntrospectionContext)childContext);
                            continue block7;
                        }
                        if (CompositeConstants.CHANNEL.equals(qname)) {
                            this.handleChannel(type, reader, (IntrospectionContext)childContext);
                            continue block7;
                        }
                        if (CompositeConstants.REFERENCE.equals(qname)) {
                            this.handleReference(type, reader, (IntrospectionContext)childContext);
                            continue block7;
                        }
                        if (CompositeConstants.COMPONENT.equals(qname)) {
                            boolean valid = this.handleComponent(type, reader, nsContext, (IntrospectionContext)childContext);
                            if (valid) continue block7;
                            this.updateContext(context, (IntrospectionContext)childContext, compositeName);
                            continue block7;
                        }
                        if (CompositeConstants.WIRE.equals(qname)) {
                            this.handleWire(type, reader, (IntrospectionContext)childContext);
                            continue block7;
                        }
                        this.handleExtensionElement(type, reader, (IntrospectionContext)childContext);
                        continue block7;
                    }
                    case 2: {
                        if (!CompositeConstants.COMPOSITE.equals(reader.getName())) continue block7;
                        this.updateAndValidateServicePromotions(type, reader, (IntrospectionContext)childContext);
                        this.updateAndValidateReferencePromotions(type, reader, (IntrospectionContext)childContext);
                        this.updateContext(context, (IntrospectionContext)childContext, compositeName);
                        return type;
                    }
                    case 5: {
                        if (!this.roundTrip) continue block7;
                        String comment = reader.getText();
                        type.addComment(comment);
                        continue block7;
                    }
                }
                if (!this.roundTrip) continue;
                String comment = reader.getText();
                type.addText(comment);
            }
        }
        catch (UnrecognizedElementException e) {
            this.updateContext(context, (IntrospectionContext)childContext, compositeName);
            UnrecognizedElement failure = new UnrecognizedElement(reader);
            context.addError((ValidationFailure)failure);
            return type;
        }
    }

    private void addNamespaces(Composite type, XMLStreamReader reader) {
        int count = reader.getNamespaceCount();
        for (int i = 0; i < count; ++i) {
            String prefix = reader.getNamespacePrefix(i);
            String uri = reader.getNamespaceURI(i);
            type.addNamespace(prefix, uri);
        }
    }

    private void handleExtensionElement(Composite type, XMLStreamReader reader, IntrospectionContext context) throws XMLStreamException {
        ModelObject modelObject;
        try {
            modelObject = (ModelObject)this.registry.load(reader, ModelObject.class, context);
        }
        catch (UnrecognizedElementException e) {
            UnrecognizedElement failure = new UnrecognizedElement(reader);
            context.addError((ValidationFailure)failure);
            return;
        }
        if (modelObject instanceof org.fabric3.model.type.component.Property) {
            type.add((org.fabric3.model.type.component.Property)modelObject);
        } else if (modelObject instanceof CompositeService) {
            type.add((ServiceDefinition)((CompositeService)modelObject));
        } else if (modelObject instanceof CompositeReference) {
            type.add((ReferenceDefinition)((CompositeReference)modelObject));
        } else if (modelObject instanceof ComponentDefinition) {
            type.add((ComponentDefinition)modelObject);
        } else if (modelObject instanceof ResourceDefinition) {
            type.add((ResourceDefinition)modelObject);
        } else if (modelObject != null) {
            context.addError((ValidationFailure)new UnrecognizedElement(reader));
        }
    }

    private void handleWire(Composite type, XMLStreamReader reader, IntrospectionContext context) throws XMLStreamException, UnrecognizedElementException {
        WireDefinition wire = (WireDefinition)this.registry.load(reader, WireDefinition.class, context);
        if (wire == null) {
            return;
        }
        type.add(wire);
    }

    private boolean handleComponent(Composite type, XMLStreamReader reader, NamespaceContext nsContext, IntrospectionContext context) throws XMLStreamException, UnrecognizedElementException {
        ComponentDefinition componentDefinition = (ComponentDefinition)this.registry.load(reader, ComponentDefinition.class, context);
        if (componentDefinition == null) {
            return false;
        }
        String key = componentDefinition.getName();
        if (type.getComponents().containsKey(key)) {
            DuplicateComponentName failure = new DuplicateComponentName(key, reader);
            context.addError((ValidationFailure)failure);
            return false;
        }
        type.add(componentDefinition);
        Implementation implementation = componentDefinition.getImplementation();
        if (implementation == null || implementation.getComponentType() == null) {
            return false;
        }
        if (type.getAutowire() != Autowire.INHERITED && componentDefinition.getAutowire() == Autowire.INHERITED) {
            componentDefinition.setAutowire(type.getAutowire());
        }
        for (PropertyValue value : componentDefinition.getPropertyValues().values()) {
            value.setNamespaceContext(nsContext);
        }
        return true;
    }

    private void handleChannel(Composite type, XMLStreamReader reader, IntrospectionContext context) throws XMLStreamException, UnrecognizedElementException {
        ChannelDefinition channelDefinition = (ChannelDefinition)this.registry.load(reader, ChannelDefinition.class, context);
        if (channelDefinition == null) {
            return;
        }
        String key = channelDefinition.getName();
        if (type.getChannels().containsKey(key)) {
            DuplicateChannelName failure = new DuplicateChannelName(key, reader);
            context.addError((ValidationFailure)failure);
            return;
        }
        type.add(channelDefinition);
    }

    private void handleReference(Composite type, XMLStreamReader reader, IntrospectionContext context) throws XMLStreamException {
        CompositeReference reference = (CompositeReference)this.referenceLoader.load(reader, context);
        if (reference == null) {
            return;
        }
        if (type.getReferences().containsKey(reference.getName())) {
            String key = reference.getName();
            DuplicatePromotedReference failure = new DuplicatePromotedReference(key, reader);
            context.addError((ValidationFailure)failure);
        } else {
            type.add((ReferenceDefinition)reference);
        }
    }

    private void handleService(Composite type, XMLStreamReader reader, IntrospectionContext context) throws XMLStreamException {
        CompositeService service = (CompositeService)this.serviceLoader.load(reader, context);
        if (service == null) {
            return;
        }
        if (type.getServices().containsKey(service.getName())) {
            String key = service.getName();
            DuplicatePromotedService failure = new DuplicatePromotedService(key, reader);
            context.addError((ValidationFailure)failure);
        } else {
            type.add((ServiceDefinition)service);
        }
    }

    private void handleProperty(Composite type, XMLStreamReader reader, IntrospectionContext context) throws XMLStreamException {
        org.fabric3.model.type.component.Property property = (org.fabric3.model.type.component.Property)this.propertyLoader.load(reader, context);
        if (property == null) {
            return;
        }
        String key = property.getName();
        if (type.getProperties().containsKey(key)) {
            DuplicateProperty failure = new DuplicateProperty(key, reader);
            context.addError((ValidationFailure)failure);
        } else {
            type.add(property);
        }
    }

    private void handleInclude(Composite type, XMLStreamReader reader, IntrospectionContext context) throws XMLStreamException, UnrecognizedElementException {
        Include include = (Include)this.registry.load(reader, Include.class, context);
        if (include == null) {
            return;
        }
        QName includeName = include.getName();
        if (type.getIncludes().containsKey(includeName)) {
            String identifier = includeName.toString();
            DuplicateInclude failure = new DuplicateInclude(identifier, reader);
            context.addError((ValidationFailure)failure);
            return;
        }
        Composite included = include.getIncluded();
        if (type.isLocal() != included.isLocal()) {
            InvalidInclude error = new InvalidInclude("Composite " + type.getName() + " has a local value of " + type.isLocal() + " and the included composite " + includeName + " has a value of " + included.isLocal(), reader);
            context.addError((ValidationFailure)error);
        }
        for (ComponentDefinition definition : included.getComponents().values()) {
            String key = definition.getName();
            if (!type.getComponents().containsKey(key)) continue;
            DuplicateComponentName failure = new DuplicateComponentName(key, reader);
            context.addError((ValidationFailure)failure);
        }
        type.add(include);
    }

    private void updateAndValidateServicePromotions(Composite type, XMLStreamReader reader, IntrospectionContext context) {
        for (ServiceDefinition definition : type.getServices().values()) {
            ServiceDefinition promotedService;
            CompositeService service = (CompositeService)definition;
            URI promotedUri = service.getPromote();
            if (promotedUri == null) {
                MissingAttribute error = new MissingAttribute("Service promotion not specified for " + service.getName() + " in composite " + type.getName(), reader);
                context.addError((ValidationFailure)error);
                continue;
            }
            String componentName = UriHelper.getDefragmentedNameAsString((URI)promotedUri);
            ComponentDefinition promotedComponent = (ComponentDefinition)type.getComponents().get(componentName);
            String name = service.getName();
            if (promotedComponent == null) {
                PromotionNotFound error = new PromotionNotFound("Component " + componentName + " referenced by " + name + " not found", reader);
                context.addError((ValidationFailure)error);
                continue;
            }
            String serviceName = promotedUri.getFragment();
            ComponentType componentType = promotedComponent.getComponentType();
            if (serviceName != null) {
                promotedService = (ServiceDefinition)componentType.getServices().get(serviceName);
                if (promotedService == null) {
                    PromotionNotFound error = new PromotionNotFound("Service " + serviceName + " promoted by " + name + " not found", reader);
                    context.addError((ValidationFailure)error);
                    continue;
                }
            } else {
                PromotionNotFound error;
                Map services = componentType.getServices();
                int numberOfServices = services.size();
                if (numberOfServices == 2) {
                    error = new PromotionNotFound("A promoted service must be specified for " + name, reader);
                    context.addError((ValidationFailure)error);
                    return;
                }
                if (numberOfServices == 1) {
                    promotedService = (ServiceDefinition)services.values().iterator().next();
                } else {
                    if (numberOfServices == 0) {
                        error = new PromotionNotFound("Component " + componentName + " has no services to promote", reader);
                        context.addError((ValidationFailure)error);
                        continue;
                    }
                    error = new PromotionNotFound("A promoted service must be specified for " + name, reader);
                    context.addError((ValidationFailure)error);
                    continue;
                }
            }
            this.processServiceContract(service, promotedService, reader, context);
        }
    }

    private void updateAndValidateReferencePromotions(Composite type, XMLStreamReader reader, IntrospectionContext context) {
        for (ReferenceDefinition definition : type.getReferences().values()) {
            CompositeReference reference = (CompositeReference)definition;
            for (URI promotedUri : reference.getPromotedUris()) {
                PromotionNotFound error;
                String componentName = UriHelper.getDefragmentedNameAsString((URI)promotedUri);
                ComponentDefinition promoted = (ComponentDefinition)type.getComponents().get(componentName);
                String referenceName = promotedUri.getFragment();
                if (promoted == null) {
                    error = new PromotionNotFound("Component " + componentName + " referenced by " + reference.getName() + " not found", reader);
                    context.addError((ValidationFailure)error);
                    return;
                }
                if (referenceName == null && promoted.getComponentType().getReferences().size() != 1) {
                    error = new PromotionNotFound("A promoted reference must be specified for " + reference.getName(), reader);
                    context.addError((ValidationFailure)error);
                    continue;
                }
                ReferenceDefinition promotedReference = referenceName == null && promoted.getComponentType().getReferences().size() == 1 ? (ReferenceDefinition)promoted.getComponentType().getReferences().values().iterator().next() : (ReferenceDefinition)promoted.getComponentType().getReferences().get(referenceName);
                if (referenceName != null && promotedReference == null) {
                    PromotionNotFound error2 = new PromotionNotFound("Reference " + referenceName + " promoted by " + reference.getName() + " not found", reader);
                    context.addError((ValidationFailure)error2);
                    continue;
                }
                this.processMultiplicity(reference, promotedReference, reader, context);
                this.processReferenceContract(reference, promotedReference, reader, context);
                ComponentReference componentReference = (ComponentReference)promoted.getReferences().get(referenceName);
                if (componentReference == null || !componentReference.isNonOverridable() || !promotedReference.getMultiplicity().equals((Object)Multiplicity.ONE_ONE) && !promotedReference.getMultiplicity().equals((Object)Multiplicity.ZERO_ONE)) continue;
                IllegalPromotion failure = new IllegalPromotion("Cannot promote a 0..1 or 1..1 non-overridable reference: " + referenceName, reader);
                context.addError((ValidationFailure)failure);
            }
        }
    }

    private void processServiceContract(CompositeService service, ServiceDefinition promotedService, XMLStreamReader reader, IntrospectionContext context) {
        if (service.getServiceContract() == null) {
            service.setServiceContract(promotedService.getServiceContract());
        } else if (this.contractMatcher != null) {
            MatchResult result = this.contractMatcher.isAssignableFrom(service.getServiceContract(), promotedService.getServiceContract(), true);
            if (!result.isAssignable()) {
                String name = service.getName();
                IncompatibleContracts error = new IncompatibleContracts("The composite service interface " + name + " is not compatible with the promoted service " + promotedService.getName() + ": " + result.getError(), reader);
                context.addError((ValidationFailure)error);
            } else {
                this.matchServiceCallbackContracts(service, promotedService, reader, context);
            }
        }
    }

    private void processReferenceContract(CompositeReference reference, ReferenceDefinition promotedReference, XMLStreamReader reader, IntrospectionContext context) {
        if (reference.getServiceContract() == null) {
            reference.setServiceContract(promotedReference.getServiceContract());
        } else if (this.contractMatcher != null) {
            ServiceContract contract;
            ServiceContract promotedContract = promotedReference.getServiceContract();
            MatchResult result = this.contractMatcher.isAssignableFrom(promotedContract, contract = reference.getServiceContract(), true);
            if (!result.isAssignable()) {
                String name = reference.getName();
                IncompatibleContracts error = new IncompatibleContracts("The composite service interface " + name + " is not compatible with the promoted service " + promotedReference.getName() + ": " + result.getError(), reader);
                context.addError((ValidationFailure)error);
            } else {
                this.matchReferenceCallbackContracts(reference, promotedReference, reader, context);
            }
        }
    }

    private void matchServiceCallbackContracts(CompositeService service, ServiceDefinition promotedService, XMLStreamReader reader, IntrospectionContext context) {
        ServiceContract callbackContract = service.getServiceContract().getCallbackContract();
        if (callbackContract == null) {
            return;
        }
        ServiceContract promotedCallbackContract = promotedService.getServiceContract().getCallbackContract();
        if (promotedCallbackContract == null) {
            IncompatibleContracts error = new IncompatibleContracts("Component type for service " + service.getName() + " does not have a callback contract", reader);
            context.addError((ValidationFailure)error);
            return;
        }
        MatchResult result = this.contractMatcher.isAssignableFrom(promotedCallbackContract, callbackContract, true);
        if (!result.isAssignable()) {
            String name = service.getName();
            IncompatibleContracts error = new IncompatibleContracts("The composite service " + name + " callback contract is not compatible with " + "the promoted service " + promotedService.getName() + " callback contract: " + result.getError(), reader);
            context.addError((ValidationFailure)error);
        }
    }

    private void matchReferenceCallbackContracts(CompositeReference reference, ReferenceDefinition promotedReference, XMLStreamReader reader, IntrospectionContext context) {
        ServiceContract callbackContract = reference.getServiceContract().getCallbackContract();
        if (callbackContract == null) {
            return;
        }
        ServiceContract promotedCallbackContract = promotedReference.getServiceContract().getCallbackContract();
        if (promotedCallbackContract == null) {
            IncompatibleContracts error = new IncompatibleContracts("Component type for reference " + reference.getName() + " does not have a callback contract", reader);
            context.addError((ValidationFailure)error);
            return;
        }
        MatchResult result = this.contractMatcher.isAssignableFrom(promotedCallbackContract, callbackContract, true);
        if (!result.isAssignable()) {
            String name = reference.getName();
            IncompatibleContracts error = new IncompatibleContracts("The composite reference " + name + " callback contract is not compatible with " + "the promoted reference " + promotedReference.getName() + " callback contract: " + result.getError(), reader);
            context.addError((ValidationFailure)error);
        }
    }

    private void processMultiplicity(CompositeReference reference, ReferenceDefinition promotedReference, XMLStreamReader reader, IntrospectionContext context) {
        if (reference.getMultiplicity() == null) {
            Multiplicity multiplicity = promotedReference.getMultiplicity();
            reference.setMultiplicity(multiplicity);
        } else {
            String name = reference.getName();
            if (!this.loaderHelper.canNarrow(reference.getMultiplicity(), promotedReference.getMultiplicity())) {
                InvalidValue failure = new InvalidValue("The multiplicity setting for reference " + name + " widens the default setting", reader);
                context.addError((ValidationFailure)failure);
            }
        }
    }

    private void updateContext(IntrospectionContext context, IntrospectionContext childContext, QName compositeName) {
        if (childContext.hasErrors() || childContext.hasWarnings()) {
            ArtifactValidationFailure artifactFailure;
            URI uri = context.getContributionUri();
            if (childContext.hasErrors()) {
                artifactFailure = new ArtifactValidationFailure(uri, compositeName.toString());
                artifactFailure.addFailures(childContext.getErrors());
                context.addError((ValidationFailure)artifactFailure);
            }
            if (childContext.hasWarnings()) {
                artifactFailure = new ArtifactValidationFailure(uri, compositeName.toString());
                artifactFailure.addFailures(childContext.getWarnings());
                context.addWarning((ValidationFailure)artifactFailure);
            }
        }
    }

    private NamespaceContext createNamespaceContext(XMLStreamReader reader) {
        StatefulNamespaceContext namespaceContext = new StatefulNamespaceContext();
        int count = reader.getNamespaceCount();
        for (int i = 0; i < count; ++i) {
            String prefix = reader.getNamespacePrefix(i);
            if (prefix == null) continue;
            String namespaceUri = reader.getNamespaceURI(prefix);
            namespaceContext.addNamespace(prefix, namespaceUri);
        }
        return namespaceContext;
    }
}

