/*
 * Decompiled with CFR 0.152.
 */
package org.fabric3.introspection.xml.composite;

import java.net.URISyntaxException;
import java.util.Collections;
import java.util.List;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import org.fabric3.host.contribution.ValidationFailure;
import org.fabric3.introspection.xml.common.BindingHelper;
import org.fabric3.introspection.xml.composite.MissingPromotion;
import org.fabric3.model.type.ModelObject;
import org.fabric3.model.type.PolicyAware;
import org.fabric3.model.type.component.BindingDefinition;
import org.fabric3.model.type.component.CompositeReference;
import org.fabric3.model.type.component.Multiplicity;
import org.fabric3.model.type.contract.ServiceContract;
import org.fabric3.spi.introspection.IntrospectionContext;
import org.fabric3.spi.introspection.xml.AbstractValidatingTypeLoader;
import org.fabric3.spi.introspection.xml.InvalidValue;
import org.fabric3.spi.introspection.xml.LoaderHelper;
import org.fabric3.spi.introspection.xml.LoaderRegistry;
import org.fabric3.spi.introspection.xml.MissingAttribute;
import org.fabric3.spi.introspection.xml.UnrecognizedElement;
import org.fabric3.spi.introspection.xml.UnrecognizedElementException;
import org.oasisopen.sca.annotation.Property;
import org.oasisopen.sca.annotation.Reference;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CompositeReferenceLoader
extends AbstractValidatingTypeLoader<CompositeReference> {
    private static final QName CALLBACK = new QName("http://docs.oasis-open.org/ns/opencsa/sca/200912", "callback");
    private LoaderRegistry registry;
    private LoaderHelper loaderHelper;
    private boolean roundTrip;

    public CompositeReferenceLoader(@Reference LoaderRegistry registry, @Reference LoaderHelper loaderHelper) {
        this.registry = registry;
        this.loaderHelper = loaderHelper;
        this.addAttributes(new String[]{"name", "autowire", "promote", "multiplicity", "requires", "policySets"});
    }

    @Property(required=false)
    public void setRoundTrip(boolean roundTrip) {
        this.roundTrip = roundTrip;
    }

    public CompositeReference load(XMLStreamReader reader, IntrospectionContext context) throws XMLStreamException {
        List promotedUris;
        this.validateAttributes(reader, context);
        String name = reader.getAttributeValue(null, "name");
        if (name == null) {
            MissingAttribute failure = new MissingAttribute("Reference name not specified", reader);
            context.addError((ValidationFailure)failure);
            return null;
        }
        boolean promoteError = false;
        try {
            promotedUris = this.loaderHelper.parseListOfUris(reader, "promote");
        }
        catch (URISyntaxException e) {
            InvalidValue error = new InvalidValue("Invalid promote URI specified on reference: " + name, reader, (Throwable)e);
            context.addError((ValidationFailure)error);
            promotedUris = Collections.emptyList();
            promoteError = true;
        }
        if (!promoteError && (promotedUris == null || promotedUris.isEmpty())) {
            MissingPromotion error = new MissingPromotion("Promotion not specified on composite reference " + name, reader);
            context.addError((ValidationFailure)error);
        }
        Multiplicity multiplicity = null;
        String multiplicityValue = reader.getAttributeValue(null, "multiplicity");
        try {
            if (multiplicityValue != null) {
                multiplicity = Multiplicity.fromString((String)multiplicityValue);
            }
        }
        catch (IllegalArgumentException e) {
            InvalidValue failure = new InvalidValue("Invalid multiplicity value: " + multiplicityValue, reader);
            context.addError((ValidationFailure)failure);
        }
        CompositeReference reference = new CompositeReference(name, promotedUris, multiplicity);
        if (this.roundTrip) {
            reference.enableRoundTrip();
            if (multiplicityValue != null) {
                reference.attributeSpecified("multiplicity");
            }
        }
        this.loaderHelper.loadPolicySetsAndIntents((PolicyAware)reference, reader, context);
        boolean callback = false;
        while (true) {
            switch (reader.next()) {
                case 1: {
                    ModelObject type;
                    callback = CALLBACK.equals(reader.getName());
                    if (callback) {
                        reader.nextTag();
                    }
                    QName elementName = reader.getName();
                    try {
                        type = (ModelObject)this.registry.load(reader, ModelObject.class, context);
                    }
                    catch (UnrecognizedElementException e) {
                        UnrecognizedElement failure = new UnrecognizedElement(reader);
                        context.addError((ValidationFailure)failure);
                        break;
                    }
                    if (type instanceof ServiceContract) {
                        reference.setServiceContract((ServiceContract)type);
                    } else {
                        boolean check;
                        if (!(type instanceof BindingDefinition)) {
                            if (type == null) break;
                            context.addError((ValidationFailure)new UnrecognizedElement(reader));
                            break;
                        }
                        BindingDefinition binding = (BindingDefinition)type;
                        if (callback) {
                            if (binding.getName() == null) {
                                BindingHelper.configureName(binding, reference.getCallbackBindings(), reader, context);
                            }
                            if (check = BindingHelper.checkDuplicateNames(binding, reference.getCallbackBindings(), reader, context)) {
                                reference.addCallbackBinding(binding);
                            }
                        } else {
                            if (binding.getName() == null) {
                                BindingHelper.configureName(binding, reference.getBindings(), reader, context);
                            }
                            if (check = BindingHelper.checkDuplicateNames(binding, reference.getBindings(), reader, context)) {
                                reference.addBinding(binding);
                            }
                        }
                    }
                    if (!reader.getName().equals(elementName) || reader.getEventType() != 2) {
                        throw new AssertionError((Object)"Loader must position the cursor to the end element");
                    }
                    break;
                }
                case 2: {
                    if (callback) {
                        callback = false;
                        break;
                    }
                    return reference;
                }
            }
        }
    }
}

