/*
 * Decompiled with CFR 0.152.
 */
package org.fabric3.introspection.xml.composite;

import java.net.URI;
import java.net.URL;
import javax.xml.namespace.NamespaceContext;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import org.fabric3.host.contribution.StoreException;
import org.fabric3.host.contribution.ValidationFailure;
import org.fabric3.host.stream.Source;
import org.fabric3.host.stream.UrlSource;
import org.fabric3.introspection.xml.common.AbstractExtensibleTypeLoader;
import org.fabric3.introspection.xml.composite.MissingComposite;
import org.fabric3.model.type.component.ComponentType;
import org.fabric3.model.type.component.Composite;
import org.fabric3.model.type.component.CompositeImplementation;
import org.fabric3.spi.contribution.MetaDataStore;
import org.fabric3.spi.contribution.ResourceElement;
import org.fabric3.spi.contribution.Symbol;
import org.fabric3.spi.contribution.manifest.QNameSymbol;
import org.fabric3.spi.introspection.DefaultIntrospectionContext;
import org.fabric3.spi.introspection.IntrospectionContext;
import org.fabric3.spi.introspection.xml.ElementLoadFailure;
import org.fabric3.spi.introspection.xml.LoaderException;
import org.fabric3.spi.introspection.xml.LoaderRegistry;
import org.fabric3.spi.introspection.xml.LoaderUtil;
import org.fabric3.spi.introspection.xml.MissingAttribute;
import org.oasisopen.sca.annotation.EagerInit;
import org.oasisopen.sca.annotation.Reference;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@EagerInit
public class ImplementationCompositeLoader
extends AbstractExtensibleTypeLoader<CompositeImplementation> {
    private static final QName IMPL = new QName("http://docs.oasis-open.org/ns/opencsa/sca/200912", "implementation.composite");
    private final MetaDataStore store;

    public ImplementationCompositeLoader(@Reference LoaderRegistry registry, @Reference MetaDataStore store) {
        super(registry);
        this.addAttributes(new String[]{"name", "scdlResource", "requires"});
        this.store = store;
    }

    @Override
    public QName getXMLType() {
        return IMPL;
    }

    public CompositeImplementation load(XMLStreamReader reader, IntrospectionContext introspectionContext) throws XMLStreamException {
        assert (CompositeImplementation.IMPLEMENTATION_COMPOSITE.equals(reader.getName()));
        this.validateAttributes(reader, introspectionContext);
        String nameAttr = reader.getAttributeValue(null, "name");
        String scdlResource = reader.getAttributeValue(null, "scdlResource");
        LoaderUtil.skipToEndElement((XMLStreamReader)reader);
        ClassLoader cl = introspectionContext.getClassLoader();
        CompositeImplementation impl = new CompositeImplementation();
        URI contributionUri = introspectionContext.getContributionUri();
        if (scdlResource != null) {
            Composite composite;
            URL url = cl.getResource(scdlResource);
            if (url == null) {
                MissingComposite failure = new MissingComposite("Composite file not found: " + scdlResource, reader);
                introspectionContext.addError((ValidationFailure)failure);
                return impl;
            }
            UrlSource source = new UrlSource(url);
            DefaultIntrospectionContext childContext = new DefaultIntrospectionContext(contributionUri, cl, url);
            try {
                composite = (Composite)this.registry.load((Source)source, Composite.class, (IntrospectionContext)childContext);
                if (childContext.hasErrors()) {
                    introspectionContext.addErrors(childContext.getErrors());
                }
                if (childContext.hasWarnings()) {
                    introspectionContext.addWarnings(childContext.getWarnings());
                }
                if (composite == null) {
                    return null;
                }
            }
            catch (LoaderException e) {
                ElementLoadFailure failure = new ElementLoadFailure("Error loading element", (Throwable)e, reader);
                introspectionContext.addError((ValidationFailure)failure);
                return null;
            }
            impl.setName(composite.getName());
            impl.setComponentType((ComponentType)composite);
            return impl;
        }
        if (nameAttr == null || nameAttr.length() == 0) {
            MissingAttribute failure = new MissingAttribute("Missing name attribute", reader);
            introspectionContext.addError((ValidationFailure)failure);
            return null;
        }
        QName name = LoaderUtil.getQName((String)nameAttr, (String)introspectionContext.getTargetNamespace(), (NamespaceContext)reader.getNamespaceContext());
        try {
            QNameSymbol symbol = new QNameSymbol(name);
            ResourceElement element = this.store.resolve(contributionUri, Composite.class, (Symbol)symbol, introspectionContext);
            if (element == null) {
                String id = name.toString();
                MissingComposite failure = new MissingComposite("Composite not found: " + id, reader);
                introspectionContext.addError((ValidationFailure)failure);
                URI uri = introspectionContext.getContributionUri();
                Composite pointer = new Composite(name, true, uri);
                impl.setComponentType((ComponentType)pointer);
                return impl;
            }
            impl.setComponentType((ComponentType)element.getValue());
            return impl;
        }
        catch (StoreException e) {
            ElementLoadFailure failure = new ElementLoadFailure("Error loading element", (Throwable)e, reader);
            introspectionContext.addError((ValidationFailure)failure);
            return null;
        }
    }
}

