/*
 * Decompiled with CFR 0.152.
 */
package org.fabric3.introspection.xml.composite;

import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import org.fabric3.host.contribution.ValidationFailure;
import org.fabric3.model.type.component.Target;
import org.fabric3.model.type.component.WireDefinition;
import org.fabric3.spi.introspection.IntrospectionContext;
import org.fabric3.spi.introspection.xml.AbstractValidatingTypeLoader;
import org.fabric3.spi.introspection.xml.InvalidTargetException;
import org.fabric3.spi.introspection.xml.InvalidValue;
import org.fabric3.spi.introspection.xml.LoaderHelper;
import org.fabric3.spi.introspection.xml.LoaderUtil;
import org.oasisopen.sca.annotation.EagerInit;
import org.oasisopen.sca.annotation.Property;
import org.oasisopen.sca.annotation.Reference;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@EagerInit
public class WireLoader
extends AbstractValidatingTypeLoader<WireDefinition> {
    private LoaderHelper helper;
    private boolean roundTrip;

    public WireLoader(@Reference LoaderHelper helper) {
        this.helper = helper;
        this.addAttributes(new String[]{"source", "target", "requires", "replace"});
    }

    @Property(required=false)
    public void setRoundTrip(boolean roundTrip) {
        this.roundTrip = roundTrip;
    }

    public WireDefinition load(XMLStreamReader reader, IntrospectionContext context) throws XMLStreamException {
        this.validateAttributes(reader, context);
        String referenceAttribute = reader.getAttributeValue(null, "source");
        String serviceAttribute = reader.getAttributeValue(null, "target");
        String replaceAttribute = reader.getAttributeValue(null, "replace");
        boolean replace = Boolean.parseBoolean(replaceAttribute);
        LoaderUtil.skipToEndElement((XMLStreamReader)reader);
        Target referenceTarget = null;
        Target serviceTarget = null;
        try {
            referenceTarget = this.helper.parseTarget(referenceAttribute, reader);
            serviceTarget = this.helper.parseTarget(serviceAttribute, reader);
        }
        catch (InvalidTargetException e) {
            InvalidValue failure = new InvalidValue("Invalid wire attribute", reader, (Throwable)e);
            context.addError((ValidationFailure)failure);
        }
        WireDefinition definition = new WireDefinition(referenceTarget, serviceTarget, replace);
        if (this.roundTrip) {
            definition.enableRoundTrip();
            if (referenceAttribute != null) {
                definition.attributeSpecified("source");
            }
            if (serviceAttribute != null) {
                definition.attributeSpecified("target");
            }
            if (replaceAttribute != null) {
                definition.attributeSpecified("replace");
            }
        }
        return definition;
    }
}

