/*
 * Decompiled with CFR 0.152.
 */
package org.fabric3.introspection.xml.definitions;

import javax.xml.namespace.NamespaceContext;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import org.fabric3.host.contribution.InstallException;
import org.fabric3.host.contribution.ValidationFailure;
import org.fabric3.spi.contribution.Resource;
import org.fabric3.spi.contribution.ResourceElement;
import org.fabric3.spi.contribution.Symbol;
import org.fabric3.spi.contribution.manifest.QNameSymbol;
import org.fabric3.spi.contribution.xml.XmlIndexer;
import org.fabric3.spi.contribution.xml.XmlIndexerRegistry;
import org.fabric3.spi.introspection.IntrospectionContext;
import org.fabric3.spi.introspection.xml.LoaderUtil;
import org.fabric3.spi.introspection.xml.MissingAttribute;
import org.oasisopen.sca.annotation.EagerInit;
import org.oasisopen.sca.annotation.Init;
import org.oasisopen.sca.annotation.Reference;

@EagerInit
public class DefinitionsIndexer
implements XmlIndexer {
    private static final QName DEFINITIONS = new QName("http://docs.oasis-open.org/ns/opencsa/sca/200912", "definitions");
    private static final QName INTENT = new QName("http://docs.oasis-open.org/ns/opencsa/sca/200912", "intent");
    private static final QName POLICY_SET = new QName("http://docs.oasis-open.org/ns/opencsa/sca/200912", "policySet");
    private static final QName BINDING_TYPE = new QName("http://docs.oasis-open.org/ns/opencsa/sca/200912", "bindingType");
    private static final QName IMPLEMENTATION_TYPE = new QName("http://docs.oasis-open.org/ns/opencsa/sca/200912", "implementationType");
    private XmlIndexerRegistry registry;

    public DefinitionsIndexer(@Reference XmlIndexerRegistry registry) {
        this.registry = registry;
    }

    @Init
    public void init() {
        this.registry.register((XmlIndexer)this);
    }

    public QName getType() {
        return DEFINITIONS;
    }

    public void index(Resource resource, XMLStreamReader reader, IntrospectionContext context) throws InstallException {
        String targetNamespace = reader.getAttributeValue(null, "targetNamespace");
        try {
            while (true) {
                switch (reader.next()) {
                    case 1: {
                        QName qname = reader.getName();
                        if (!INTENT.equals(qname) && !POLICY_SET.equals(qname) && !BINDING_TYPE.equals(qname) && !IMPLEMENTATION_TYPE.equals(qname)) break;
                        String nameAttr = reader.getAttributeValue(null, "name");
                        if (nameAttr == null) {
                            context.addError((ValidationFailure)new MissingAttribute("Definition name not specified", reader));
                            return;
                        }
                        NamespaceContext namespaceContext = reader.getNamespaceContext();
                        QName name = LoaderUtil.getQName((String)nameAttr, (String)targetNamespace, (NamespaceContext)namespaceContext);
                        QNameSymbol symbol = new QNameSymbol(name);
                        ResourceElement element = new ResourceElement((Symbol)symbol);
                        resource.addResourceElement(element);
                        break;
                    }
                    case 8: {
                        return;
                    }
                }
            }
        }
        catch (XMLStreamException e) {
            throw new InstallException((Throwable)e);
        }
    }
}

