/*
 * Decompiled with CFR 0.152.
 */
package org.fabric3.introspection.xml.definitions;

import java.net.URI;
import java.util.Set;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import org.fabric3.host.contribution.ValidationFailure;
import org.fabric3.model.type.definitions.ImplementationType;
import org.fabric3.spi.introspection.IntrospectionContext;
import org.fabric3.spi.introspection.xml.AbstractValidatingTypeLoader;
import org.fabric3.spi.introspection.xml.InvalidPrefixException;
import org.fabric3.spi.introspection.xml.InvalidQNamePrefix;
import org.fabric3.spi.introspection.xml.InvalidValue;
import org.fabric3.spi.introspection.xml.LoaderHelper;
import org.fabric3.spi.introspection.xml.LoaderUtil;
import org.oasisopen.sca.annotation.EagerInit;
import org.oasisopen.sca.annotation.Reference;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@EagerInit
public class ImplementationTypeLoader
extends AbstractValidatingTypeLoader<ImplementationType> {
    private final LoaderHelper helper;

    public ImplementationTypeLoader(@Reference LoaderHelper helper) {
        this.helper = helper;
        this.addAttributes(new String[]{"name", "alwaysProvides", "mayProvide"});
    }

    public ImplementationType load(XMLStreamReader reader, IntrospectionContext context) throws XMLStreamException {
        this.validateAttributes(reader, context);
        try {
            String name = reader.getAttributeValue(null, "name");
            QName qName = this.helper.createQName(name, reader);
            if (!qName.getLocalPart().startsWith("implementation.")) {
                InvalidValue error = new InvalidValue("Invalid implementation value", reader);
                context.addError((ValidationFailure)error);
            }
            Set alwaysProvides = this.helper.parseListOfQNames(reader, "alwaysProvides");
            Set mayProvide = this.helper.parseListOfQNames(reader, "mayProvide");
            LoaderUtil.skipToEndElement((XMLStreamReader)reader);
            return new ImplementationType(qName, alwaysProvides, mayProvide);
        }
        catch (InvalidPrefixException e) {
            String prefix = e.getPrefix();
            URI uri = context.getContributionUri();
            context.addError((ValidationFailure)new InvalidQNamePrefix("The prefix " + prefix + " specified in the definitions.xml file in contribution " + uri + " is invalid", reader));
            return null;
        }
    }
}

