/*
 * Decompiled with CFR 0.152.
 */
package org.fabric3.introspection.xml.plan;

import javax.xml.namespace.QName;
import javax.xml.stream.XMLStreamReader;
import org.fabric3.host.contribution.ValidationFailure;
import org.fabric3.introspection.xml.plan.DeploymentPlanConstants;
import org.fabric3.spi.contribution.Resource;
import org.fabric3.spi.contribution.ResourceElement;
import org.fabric3.spi.contribution.Symbol;
import org.fabric3.spi.contribution.manifest.QNameSymbol;
import org.fabric3.spi.contribution.xml.XmlIndexer;
import org.fabric3.spi.contribution.xml.XmlIndexerRegistry;
import org.fabric3.spi.introspection.IntrospectionContext;
import org.fabric3.spi.introspection.xml.MissingAttribute;
import org.oasisopen.sca.annotation.EagerInit;
import org.oasisopen.sca.annotation.Init;
import org.oasisopen.sca.annotation.Reference;

@EagerInit
public class DeploymentPlanIndexer
implements XmlIndexer {
    private XmlIndexerRegistry registry;

    public DeploymentPlanIndexer(@Reference XmlIndexerRegistry registry) {
        this.registry = registry;
    }

    @Init
    public void init() {
        this.registry.register((XmlIndexer)this);
    }

    public QName getType() {
        return DeploymentPlanConstants.PLAN;
    }

    public void index(Resource resource, XMLStreamReader reader, IntrospectionContext context) {
        QName qname = reader.getName();
        assert (DeploymentPlanConstants.PLAN.equals(qname));
        String name = reader.getAttributeValue(null, "name");
        if (name == null) {
            context.addError((ValidationFailure)new MissingAttribute("Deployment plan name not specified", reader));
            return;
        }
        QName planQName = new QName("urn:fabric3.org:extension:plan", name);
        QNameSymbol symbol = new QNameSymbol(planQName);
        ResourceElement element = new ResourceElement((Symbol)symbol);
        resource.addResourceElement(element);
    }
}

