/*
 * Decompiled with CFR 0.152.
 */
package org.fabric3.introspection.xml.plan;

import javax.xml.namespace.NamespaceContext;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import org.fabric3.host.contribution.InstallException;
import org.fabric3.host.contribution.ValidationFailure;
import org.fabric3.introspection.xml.plan.DeploymentPlanConstants;
import org.fabric3.spi.contribution.Resource;
import org.fabric3.spi.contribution.ResourceElement;
import org.fabric3.spi.contribution.ResourceState;
import org.fabric3.spi.contribution.manifest.QNameSymbol;
import org.fabric3.spi.contribution.xml.XmlResourceElementLoader;
import org.fabric3.spi.contribution.xml.XmlResourceElementLoaderRegistry;
import org.fabric3.spi.introspection.IntrospectionContext;
import org.fabric3.spi.introspection.xml.LoaderUtil;
import org.fabric3.spi.introspection.xml.MissingAttribute;
import org.fabric3.spi.plan.DeploymentPlan;
import org.oasisopen.sca.annotation.EagerInit;
import org.oasisopen.sca.annotation.Init;
import org.oasisopen.sca.annotation.Reference;

@EagerInit
public class DeploymentPlanProcessor
implements XmlResourceElementLoader {
    private static final QName DEPLOYABLE_MAPPING = new QName("urn:fabric3.org", "mapping");
    private XmlResourceElementLoaderRegistry registry;

    public DeploymentPlanProcessor(@Reference XmlResourceElementLoaderRegistry registry) {
        this.registry = registry;
    }

    public QName getType() {
        return DeploymentPlanConstants.PLAN;
    }

    @Init
    public void init() {
        this.registry.register((XmlResourceElementLoader)this);
    }

    public void load(XMLStreamReader reader, Resource resource, IntrospectionContext context) throws InstallException {
        try {
            QName qname = reader.getName();
            assert (DeploymentPlanConstants.PLAN.equals(qname));
            String planName = reader.getAttributeValue(null, "name");
            if (planName == null) {
                context.addError((ValidationFailure)new MissingAttribute("Deployment plan name not specified", reader));
                return;
            }
            DeploymentPlan plan = new DeploymentPlan(planName);
            block6: while (true) {
                switch (reader.next()) {
                    case 1: {
                        qname = reader.getName();
                        if (!DEPLOYABLE_MAPPING.equals(qname) || this.processDeployableMapping(plan, reader, context)) continue block6;
                        return;
                    }
                    case 2: {
                        QName name = reader.getName();
                        if (!DeploymentPlanConstants.PLAN.equals(name)) break;
                        this.updatePlan(resource, plan);
                        return;
                    }
                }
            }
        }
        catch (XMLStreamException e) {
            throw new InstallException("Error processing contribution: " + context.getContributionUri(), (Throwable)e);
        }
    }

    private boolean processDeployableMapping(DeploymentPlan plan, XMLStreamReader reader, IntrospectionContext context) {
        String deployableName = reader.getAttributeValue(null, "deployable");
        if (deployableName == null) {
            context.addError((ValidationFailure)new MissingAttribute("Deployable name not specified in mapping", reader));
            return false;
        }
        QName deployable = LoaderUtil.getQName((String)deployableName, null, (NamespaceContext)reader.getNamespaceContext());
        String zoneName = reader.getAttributeValue(null, "zone");
        if (zoneName == null) {
            context.addError((ValidationFailure)new MissingAttribute("Zone not specified in mapping", reader));
            return false;
        }
        plan.addDeployableMapping(deployable, zoneName);
        return true;
    }

    private void updatePlan(Resource resource, DeploymentPlan plan) {
        String name = plan.getName();
        QName planQName = new QName("urn:fabric3.org:extension:plan", name);
        QNameSymbol symbol = new QNameSymbol(planQName);
        boolean found = false;
        for (ResourceElement element : resource.getResourceElements()) {
            if (!element.getSymbol().equals((Object)symbol)) continue;
            element.setValue((Object)plan);
            found = true;
            break;
        }
        if (!found) {
            throw new AssertionError((Object)("Deployment plan not found: " + name));
        }
        resource.setState(ResourceState.PROCESSED);
    }
}

