/*
 * Decompiled with CFR 0.152.
 */
package org.fabric3.binding.ws.metro.contribution;

import org.fabric3.host.Version;
import org.fabric3.spi.contribution.Contribution;
import org.fabric3.spi.contribution.ContributionManifest;
import org.fabric3.spi.contribution.ContributionServiceListener;
import org.fabric3.spi.contribution.Import;
import org.fabric3.spi.contribution.manifest.JavaImport;
import org.fabric3.spi.contribution.manifest.PackageInfo;

public class MetroContributionServiceListener
implements ContributionServiceListener {
    private JavaImport saajImport;
    private JavaImport wsImport;
    private JavaImport sunSaajImport;

    public MetroContributionServiceListener() {
        PackageInfo wsInfo = new PackageInfo("javax.xml.ws.*");
        wsInfo.setMinVersion(new Version("2.2.0"));
        this.wsImport = new JavaImport(wsInfo);
        PackageInfo saajInfo = new PackageInfo("javax.xml.soap.*");
        saajInfo.setMinVersion(new Version("1.3.0"));
        this.saajImport = new JavaImport(saajInfo);
        PackageInfo sunSaajInfo = new PackageInfo("com.sun.xml.messaging.saaj.*");
        sunSaajInfo.setMinVersion(new Version("2.0.1"));
        this.sunSaajImport = new JavaImport(sunSaajInfo);
    }

    public void onProcessManifest(Contribution contribution) {
        if (contribution.getManifest().isExtension()) {
            return;
        }
        boolean saajImported = false;
        boolean wsImported = false;
        boolean sunImported = false;
        ContributionManifest manifest = contribution.getManifest();
        for (Import imprt : manifest.getImports()) {
            if (!(imprt instanceof JavaImport)) continue;
            JavaImport contributionImport = (JavaImport)imprt;
            String name = contributionImport.getPackageInfo().getName();
            if (name.equals("javax.xml.soap.*")) {
                saajImported = true;
                continue;
            }
            if (name.equals("javax.xml.ws.*")) {
                wsImported = true;
                continue;
            }
            if (!name.equals("com.sun.xml.messaging.saaj.*")) continue;
            sunImported = true;
        }
        if (!saajImported) {
            manifest.addImport((Import)this.saajImport);
        }
        if (!wsImported) {
            manifest.addImport((Import)this.wsImport);
        }
        if (!sunImported) {
            manifest.addImport((Import)this.sunSaajImport);
        }
    }

    public void onStore(Contribution contribution) {
    }

    public void onInstall(Contribution contribution) {
    }

    public void onUpdate(Contribution contribution) {
    }

    public void onUninstall(Contribution contribution) {
    }

    public void onRemove(Contribution contribution) {
    }
}

