/*
 * Decompiled with CFR 0.152.
 */
package org.fabric3.binding.ws.metro.generator.java;

import com.sun.xml.ws.api.BindingID;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.StringWriter;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.jws.WebService;
import javax.wsdl.Definition;
import javax.xml.namespace.QName;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.fabric3.binding.ws.metro.generator.GenerationHelper;
import org.fabric3.binding.ws.metro.generator.MetroGeneratorDelegate;
import org.fabric3.binding.ws.metro.generator.PolicyExpressionMapping;
import org.fabric3.binding.ws.metro.generator.WsdlElement;
import org.fabric3.binding.ws.metro.generator.java.EndpointSynthesizer;
import org.fabric3.binding.ws.metro.generator.java.codegen.GeneratedInterface;
import org.fabric3.binding.ws.metro.generator.java.codegen.InterfaceGenerator;
import org.fabric3.binding.ws.metro.generator.java.wsdl.GeneratedArtifacts;
import org.fabric3.binding.ws.metro.generator.java.wsdl.JavaWsdlGenerator;
import org.fabric3.binding.ws.metro.generator.policy.WsdlPolicyAttacher;
import org.fabric3.binding.ws.metro.generator.resolver.EndpointResolver;
import org.fabric3.binding.ws.metro.generator.resolver.TargetUrlResolver;
import org.fabric3.binding.ws.metro.generator.resolver.WsdlResolver;
import org.fabric3.binding.ws.metro.provision.ConnectionConfiguration;
import org.fabric3.binding.ws.metro.provision.MetroJavaSourceDefinition;
import org.fabric3.binding.ws.metro.provision.MetroJavaTargetDefinition;
import org.fabric3.binding.ws.metro.provision.MetroTargetDefinition;
import org.fabric3.binding.ws.metro.provision.ReferenceEndpointDefinition;
import org.fabric3.binding.ws.metro.provision.SecurityConfiguration;
import org.fabric3.binding.ws.metro.provision.ServiceEndpointDefinition;
import org.fabric3.binding.ws.metro.util.BindingIdResolver;
import org.fabric3.binding.ws.metro.util.ClassLoaderUpdater;
import org.fabric3.binding.ws.model.WsBindingDefinition;
import org.fabric3.host.runtime.HostInfo;
import org.fabric3.model.type.definitions.Intent;
import org.fabric3.model.type.definitions.PolicySet;
import org.fabric3.spi.classloader.ClassLoaderRegistry;
import org.fabric3.spi.classloader.MultiParentClassLoader;
import org.fabric3.spi.generator.EffectivePolicy;
import org.fabric3.spi.generator.GenerationException;
import org.fabric3.spi.model.instance.Bindable;
import org.fabric3.spi.model.instance.LogicalBinding;
import org.fabric3.spi.model.instance.LogicalComponent;
import org.fabric3.spi.model.physical.PhysicalBindingHandlerDefinition;
import org.fabric3.spi.model.type.java.JavaServiceContract;
import org.oasisopen.sca.annotation.Reference;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.xml.sax.SAXException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JavaGeneratorDelegate
implements MetroGeneratorDelegate<JavaServiceContract> {
    private static final String REPLACEABLE_ADDRESS = "REPLACE_WITH_ACTUAL_URL";
    private WsdlResolver wsdlResolver;
    private EndpointResolver endpointResolver;
    private EndpointSynthesizer synthesizer;
    private JavaWsdlGenerator wsdlGenerator;
    private InterfaceGenerator interfaceGenerator;
    private BindingIdResolver bindingIdResolver;
    private WsdlPolicyAttacher policyAttacher;
    private ClassLoaderRegistry classLoaderRegistry;
    private ClassLoaderUpdater classLoaderUpdater;
    private TargetUrlResolver targetUrlResolver;
    private HostInfo info;
    private DocumentBuilder documentBuilder;
    private TransformerFactory transformerFactory;

    public JavaGeneratorDelegate(@Reference WsdlResolver wsdlResolver, @Reference EndpointResolver endpointResolver, @Reference EndpointSynthesizer synthesizer, @Reference JavaWsdlGenerator wsdlGenerator, @Reference InterfaceGenerator interfaceGenerator, @Reference BindingIdResolver bindingIdResolver, @Reference WsdlPolicyAttacher policyAttacher, @Reference ClassLoaderRegistry classLoaderRegistry, @Reference ClassLoaderUpdater classLoaderUpdater, @Reference TargetUrlResolver targetUrlResolver, @Reference HostInfo info) throws ParserConfigurationException {
        this.wsdlResolver = wsdlResolver;
        this.endpointResolver = endpointResolver;
        this.synthesizer = synthesizer;
        this.wsdlGenerator = wsdlGenerator;
        this.interfaceGenerator = interfaceGenerator;
        this.bindingIdResolver = bindingIdResolver;
        this.policyAttacher = policyAttacher;
        this.classLoaderRegistry = classLoaderRegistry;
        this.classLoaderUpdater = classLoaderUpdater;
        this.targetUrlResolver = targetUrlResolver;
        this.info = info;
        this.documentBuilder = DocumentBuilderFactory.newInstance().newDocumentBuilder();
        this.transformerFactory = TransformerFactory.newInstance();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MetroJavaSourceDefinition generateSource(LogicalBinding<WsBindingDefinition> binding, JavaServiceContract contract, EffectivePolicy policy) throws GenerationException {
        Class<?> serviceClass = this.loadServiceClass(contract);
        WsBindingDefinition definition = (WsBindingDefinition)binding.getDefinition();
        URL wsdlLocation = this.getWsdlLocation(definition, serviceClass);
        ServiceEndpointDefinition endpointDefinition = this.createServiceEndpointDefinition(binding, contract, serviceClass, wsdlLocation);
        String interfaze = contract.getQualifiedInterfaceName();
        ArrayList<QName> intentNames = new ArrayList<QName>();
        Set endpointIntents = policy.getEndpointIntents();
        for (Intent intent : endpointIntents) {
            intentNames.add(intent.getName());
        }
        ArrayList<Element> policyExpressions = new ArrayList<Element>();
        for (PolicySet policySet : policy.getEndpointPolicySets()) {
            policyExpressions.add(policySet.getExpression());
        }
        List<PolicyExpressionMapping> mappings = GenerationHelper.createMappings(policy, serviceClass);
        List<PhysicalBindingHandlerDefinition> handlers = GenerationHelper.generateBindingHandlers(this.info.getDomain(), definition);
        byte[] generatedBytes = null;
        String wsdl = null;
        Map<String, String> schemas = Collections.emptyMap();
        this.classLoaderUpdater.updateClassLoader(serviceClass);
        ClassLoader old = Thread.currentThread().getContextClassLoader();
        try {
            Thread.currentThread().setContextClassLoader(serviceClass.getClassLoader());
            if (this.interfaceGenerator.doGeneration(serviceClass)) {
                GeneratedInterface generatedInterface = this.interfaceGenerator.generate(serviceClass, null, null, null, null);
                generatedBytes = generatedInterface.getBytes();
                serviceClass = generatedInterface.getGeneratedClass();
                interfaze = serviceClass.getName();
            }
            if (!policyExpressions.isEmpty() || !mappings.isEmpty()) {
                BindingID bindingId = this.bindingIdResolver.resolveBindingId(intentNames);
                QName name = endpointDefinition.getServiceName();
                GeneratedArtifacts artifacts = this.wsdlGenerator.generate(serviceClass, name, REPLACEABLE_ADDRESS, bindingId);
                wsdl = artifacts.getWsdl();
                schemas = artifacts.getSchemas();
                wsdl = this.mergePolicy(wsdl, policyExpressions, mappings);
            }
            URI classLoaderUri = null;
            if (serviceClass.getClassLoader() instanceof MultiParentClassLoader) {
                classLoaderUri = ((MultiParentClassLoader)serviceClass.getClassLoader()).getName();
            }
            MetroJavaSourceDefinition metroJavaSourceDefinition = new MetroJavaSourceDefinition(endpointDefinition, interfaze, generatedBytes, classLoaderUri, wsdl, schemas, intentNames, wsdlLocation, handlers);
            return metroJavaSourceDefinition;
        }
        finally {
            Thread.currentThread().setContextClassLoader(old);
        }
    }

    @Override
    public MetroTargetDefinition generateTarget(LogicalBinding<WsBindingDefinition> binding, JavaServiceContract contract, EffectivePolicy policy) throws GenerationException {
        URL targetUrl = null;
        URI targetUri = ((WsBindingDefinition)binding.getDefinition()).getTargetUri();
        if (targetUri != null) {
            try {
                targetUrl = targetUri.toURL();
            }
            catch (MalformedURLException e) {
                throw new GenerationException((Throwable)e);
            }
        }
        return this.generateTarget(binding, targetUrl, contract, policy);
    }

    @Override
    public MetroTargetDefinition generateServiceBindingTarget(LogicalBinding<WsBindingDefinition> serviceBinding, JavaServiceContract contract, EffectivePolicy policy) throws GenerationException {
        URL targetUrl = this.targetUrlResolver.resolveUrl(serviceBinding, policy);
        return this.generateTarget(serviceBinding, targetUrl, contract, policy);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private MetroTargetDefinition generateTarget(LogicalBinding<WsBindingDefinition> binding, URL targetUrl, JavaServiceContract contract, EffectivePolicy policy) throws GenerationException {
        Class<?> serviceClass = this.loadServiceClass(contract);
        WsBindingDefinition definition = (WsBindingDefinition)binding.getDefinition();
        URL wsdlLocation = this.getWsdlLocation(definition, serviceClass);
        ReferenceEndpointDefinition endpointDefinition = this.createReferenceEndpointDefinition(binding, contract, serviceClass, targetUrl, wsdlLocation);
        String interfaze = contract.getQualifiedInterfaceName();
        Set endpointIntents = policy.getEndpointIntents();
        ArrayList<QName> intentNames = new ArrayList<QName>();
        for (Intent intent : endpointIntents) {
            intentNames.add(intent.getName());
        }
        ArrayList<Element> policyExpressions = new ArrayList<Element>();
        for (PolicySet policySet : policy.getEndpointPolicySets()) {
            policyExpressions.add(policySet.getExpression());
        }
        List<PolicyExpressionMapping> mappings = GenerationHelper.createMappings(policy, serviceClass);
        List<PhysicalBindingHandlerDefinition> handlers = GenerationHelper.generateBindingHandlers(this.info.getDomain(), definition);
        byte[] generatedBytes = null;
        String wsdl = null;
        Map<String, String> schemas = Collections.emptyMap();
        this.classLoaderUpdater.updateClassLoader(serviceClass);
        ClassLoader old = Thread.currentThread().getContextClassLoader();
        try {
            Thread.currentThread().setContextClassLoader(serviceClass.getClassLoader());
            if (this.interfaceGenerator.doGeneration(serviceClass)) {
                GeneratedInterface generatedInterface = this.interfaceGenerator.generate(serviceClass, null, null, null, null);
                generatedBytes = generatedInterface.getBytes();
                serviceClass = generatedInterface.getGeneratedClass();
                interfaze = serviceClass.getName();
            }
            if (!policyExpressions.isEmpty() || !mappings.isEmpty()) {
                BindingID bindingId = this.bindingIdResolver.resolveBindingId(intentNames);
                QName name = endpointDefinition.getServiceName();
                String address = endpointDefinition.getUrl().toString();
                GeneratedArtifacts artifacts = this.wsdlGenerator.generate(serviceClass, name, address, bindingId);
                wsdl = artifacts.getWsdl();
                schemas = artifacts.getSchemas();
                wsdl = this.mergePolicy(wsdl, policyExpressions, mappings);
            } else if (endpointDefinition.getWsdl() != null) {
                wsdl = endpointDefinition.getWsdl();
            }
        }
        finally {
            Thread.currentThread().setContextClassLoader(old);
        }
        SecurityConfiguration securityConfiguration = GenerationHelper.createSecurityConfiguration(definition);
        ConnectionConfiguration connectionConfiguration = GenerationHelper.createConnectionConfiguration(definition);
        URI classLoaderUri = null;
        if (serviceClass.getClassLoader() instanceof MultiParentClassLoader) {
            classLoaderUri = ((MultiParentClassLoader)serviceClass.getClassLoader()).getName();
        }
        int retries = definition.getRetries();
        return new MetroJavaTargetDefinition(endpointDefinition, interfaze, generatedBytes, classLoaderUri, wsdl, schemas, wsdlLocation, intentNames, securityConfiguration, connectionConfiguration, retries, handlers);
    }

    private URL getWsdlLocation(WsBindingDefinition definition, Class<?> serviceClass) throws GenerationException {
        try {
            String location = definition.getWsdlLocation();
            if (location != null) {
                return new URL(location);
            }
            WebService annotation = serviceClass.getAnnotation(WebService.class);
            if (annotation != null) {
                String wsdlLocation = annotation.wsdlLocation();
                if (wsdlLocation.length() > 0) {
                    return new URL(wsdlLocation);
                }
                return null;
            }
        }
        catch (MalformedURLException e) {
            throw new GenerationException((Throwable)e);
        }
        return null;
    }

    private Class<?> loadServiceClass(JavaServiceContract javaContract) {
        Class<?> clazz;
        ClassLoader loader;
        if (this.info.supportsClassLoaderIsolation()) {
            URI classLoaderUri = javaContract.getContributionClassLoaderUri();
            if (classLoaderUri == null) {
                loader = Thread.currentThread().getContextClassLoader();
            } else {
                loader = this.classLoaderRegistry.getClassLoader(classLoaderUri);
                if (loader == null) {
                    throw new AssertionError((Object)("Classloader not found: " + classLoaderUri));
                }
            }
        } else {
            loader = Thread.currentThread().getContextClassLoader();
        }
        try {
            clazz = loader.loadClass(javaContract.getInterfaceClass());
        }
        catch (ClassNotFoundException e) {
            throw new AssertionError((Object)e);
        }
        return clazz;
    }

    private ServiceEndpointDefinition createServiceEndpointDefinition(LogicalBinding<WsBindingDefinition> binding, JavaServiceContract contract, Class<?> serviceClass, URL wsdlLocation) throws GenerationException {
        ServiceEndpointDefinition endpointDefinition;
        URI targetUri = ((WsBindingDefinition)binding.getDefinition()).getTargetUri();
        if (targetUri != null) {
            endpointDefinition = this.synthesizer.synthesizeServiceEndpoint(contract, serviceClass, targetUri);
        } else {
            String wsdlElementString = ((WsBindingDefinition)binding.getDefinition()).getWsdlElement();
            if (wsdlElementString == null) {
                Bindable service = (Bindable)binding.getParent();
                for (LogicalBinding otherBinding : service.getBindings()) {
                    WsBindingDefinition wsDefinition;
                    if (binding == otherBinding || !WsBindingDefinition.BINDING_QNAME.equals(otherBinding.getDefinition().getType()) || (wsDefinition = (WsBindingDefinition)otherBinding.getDefinition()).getTargetUri() != null || wsDefinition.getWsdlElement() != null) continue;
                    throw new GenerationException("If there is more than one web service binding, one must provide a URI or WSDLElement:" + service.getUri());
                }
                targetUri = URI.create(service.getUri().getFragment());
                return this.synthesizer.synthesizeServiceEndpoint(contract, serviceClass, targetUri);
            }
            WsdlElement wsdlElement = GenerationHelper.parseWsdlElement(wsdlElementString);
            if (wsdlLocation == null) {
                URI contributionUri = ((LogicalComponent)((Bindable)binding.getParent()).getParent()).getDefinition().getContributionUri();
                Definition wsdl = this.wsdlResolver.resolveWsdlByPortName(contributionUri, wsdlElement.getPortName());
                endpointDefinition = this.endpointResolver.resolveServiceEndpoint(wsdlElement, wsdl);
            } else {
                Definition wsdl = this.wsdlResolver.parseWsdl(wsdlLocation);
                endpointDefinition = this.endpointResolver.resolveServiceEndpoint(wsdlElement, wsdl);
            }
        }
        return endpointDefinition;
    }

    private String mergePolicy(String wsdl, List<Element> policyExpressions, List<PolicyExpressionMapping> mappings) throws GenerationException {
        try {
            Document wsdlDocument = this.documentBuilder.parse(new ByteArrayInputStream(wsdl.getBytes()));
            this.policyAttacher.attach(wsdlDocument, policyExpressions, mappings);
            DOMSource source = new DOMSource(wsdlDocument);
            StringWriter writer = new StringWriter();
            StreamResult result = new StreamResult(writer);
            Transformer transformer = this.transformerFactory.newTransformer();
            transformer.transform(source, result);
            return writer.toString();
        }
        catch (IOException e) {
            throw new GenerationException((Throwable)e);
        }
        catch (SAXException e) {
            throw new GenerationException((Throwable)e);
        }
        catch (TransformerException e) {
            throw new GenerationException((Throwable)e);
        }
    }

    private ReferenceEndpointDefinition createReferenceEndpointDefinition(LogicalBinding<WsBindingDefinition> binding, JavaServiceContract contract, Class<?> serviceClass, URL targetUrl, URL wsdlLocation) throws GenerationException {
        ReferenceEndpointDefinition endpointDefinition;
        WsBindingDefinition definition = (WsBindingDefinition)binding.getDefinition();
        if (targetUrl != null) {
            endpointDefinition = this.synthesizer.synthesizeReferenceEndpoint(contract, serviceClass, targetUrl);
        } else {
            WsdlElement wsdlElement = GenerationHelper.parseWsdlElement(definition.getWsdlElement());
            if (wsdlLocation == null) {
                URI contributionUri = ((LogicalComponent)((Bindable)binding.getParent()).getParent()).getDefinition().getContributionUri();
                Definition wsdl = this.wsdlResolver.resolveWsdlByPortName(contributionUri, wsdlElement.getPortName());
                endpointDefinition = this.endpointResolver.resolveReferenceEndpoint(wsdlElement, wsdl);
            } else {
                Definition wsdl = this.wsdlResolver.parseWsdl(wsdlLocation);
                endpointDefinition = this.endpointResolver.resolveReferenceEndpoint(wsdlElement, wsdl);
            }
        }
        return endpointDefinition;
    }
}

